/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitmapCollection {
    private final int _numDocs;
    private boolean _inverted;
    private final ImmutableRoaringBitmap[] _bitmaps;

    public BitmapCollection(int numDocs, boolean inverted, ImmutableRoaringBitmap ... bitmaps) {
        this._numDocs = numDocs;
        this._inverted = inverted;
        this._bitmaps = bitmaps;
    }

    public BitmapCollection invert() {
        this._inverted = !this._inverted;
        return this;
    }

    public int andCardinality(BitmapCollection bitmaps) {
        ImmutableRoaringBitmap left = this.reduceInternal();
        ImmutableRoaringBitmap right = bitmaps.reduceInternal();
        if (!this._inverted) {
            if (!bitmaps._inverted) {
                return ImmutableRoaringBitmap.andCardinality((ImmutableRoaringBitmap)left, (ImmutableRoaringBitmap)right);
            }
            return ImmutableRoaringBitmap.andNotCardinality((ImmutableRoaringBitmap)left, (ImmutableRoaringBitmap)right);
        }
        if (!bitmaps._inverted) {
            return ImmutableRoaringBitmap.andNotCardinality((ImmutableRoaringBitmap)right, (ImmutableRoaringBitmap)left);
        }
        return this._numDocs - ImmutableRoaringBitmap.orCardinality((ImmutableRoaringBitmap)left, (ImmutableRoaringBitmap)right);
    }

    public int orCardinality(BitmapCollection bitmaps) {
        ImmutableRoaringBitmap left = this.reduceInternal();
        ImmutableRoaringBitmap right = bitmaps.reduceInternal();
        if (!this._inverted) {
            if (!bitmaps._inverted) {
                return ImmutableRoaringBitmap.orCardinality((ImmutableRoaringBitmap)left, (ImmutableRoaringBitmap)right);
            }
            return this._numDocs - right.getCardinality() - ImmutableRoaringBitmap.andCardinality((ImmutableRoaringBitmap)left, (ImmutableRoaringBitmap)right);
        }
        if (!bitmaps._inverted) {
            return this._numDocs - left.getCardinality() + ImmutableRoaringBitmap.andCardinality((ImmutableRoaringBitmap)right, (ImmutableRoaringBitmap)left);
        }
        return this._numDocs - ImmutableRoaringBitmap.andCardinality((ImmutableRoaringBitmap)left, (ImmutableRoaringBitmap)right);
    }

    private ImmutableRoaringBitmap reduceInternal() {
        if (this._bitmaps.length == 1) {
            return this._bitmaps[0];
        }
        return BufferFastAggregation.or((ImmutableRoaringBitmap[])this._bitmaps);
    }

    public ImmutableRoaringBitmap reduce() {
        if (!this._inverted) {
            return this.reduceInternal();
        }
        return this.invertedOr();
    }

    private MutableRoaringBitmap invertedOr() {
        MutableRoaringBitmap complement = new MutableRoaringBitmap();
        complement.add(0L, (long)this._numDocs);
        for (ImmutableRoaringBitmap bitmap : this._bitmaps) {
            complement.andNot(bitmap);
        }
        return complement;
    }
}

