/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docidsets;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.BitmapBasedDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.BitmapDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.OrDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.SortedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.spi.utils.Pairs;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class OrDocIdSet
implements FilterBlockDocIdSet {
    private final List<FilterBlockDocIdSet> _docIdSets;
    private final int _numDocs;

    public OrDocIdSet(List<FilterBlockDocIdSet> docIdSets, int numDocs) {
        this._docIdSets = docIdSets;
        this._numDocs = numDocs;
    }

    @Override
    public BlockDocIdIterator iterator() {
        int numBitmapBasedDocIdIterators;
        int numDocIdSets = this._docIdSets.size();
        BlockDocIdIterator[] allDocIdIterators = new BlockDocIdIterator[numDocIdSets];
        ArrayList<SortedDocIdIterator> sortedDocIdIterators = new ArrayList<SortedDocIdIterator>();
        ArrayList<BitmapBasedDocIdIterator> bitmapBasedDocIdIterators = new ArrayList<BitmapBasedDocIdIterator>();
        ArrayList<BlockDocIdIterator> remainingDocIdIterators = new ArrayList<BlockDocIdIterator>();
        for (int i = 0; i < numDocIdSets; ++i) {
            BlockDocIdIterator docIdIterator;
            allDocIdIterators[i] = docIdIterator = this._docIdSets.get(i).iterator();
            if (docIdIterator instanceof SortedDocIdIterator) {
                sortedDocIdIterators.add((SortedDocIdIterator)docIdIterator);
                continue;
            }
            if (docIdIterator instanceof BitmapBasedDocIdIterator) {
                bitmapBasedDocIdIterators.add((BitmapBasedDocIdIterator)docIdIterator);
                continue;
            }
            remainingDocIdIterators.add(docIdIterator);
        }
        int numSortedDocIdIterators = sortedDocIdIterators.size();
        if (numSortedDocIdIterators + (numBitmapBasedDocIdIterators = bitmapBasedDocIdIterators.size()) > 1) {
            MutableRoaringBitmap docIds = new MutableRoaringBitmap();
            for (SortedDocIdIterator sortedDocIdIterator : sortedDocIdIterators) {
                for (Pairs.IntPair docIdRange : sortedDocIdIterator.getDocIdRanges()) {
                    docIds.add((long)docIdRange.getLeft(), (long)docIdRange.getRight() + 1L);
                }
            }
            for (BitmapBasedDocIdIterator bitmapBasedDocIdIterator : bitmapBasedDocIdIterators) {
                docIds.or(bitmapBasedDocIdIterator.getDocIds());
            }
            BitmapDocIdIterator bitmapDocIdIterator = new BitmapDocIdIterator((ImmutableRoaringBitmap)docIds, this._numDocs);
            int numRemainingDocIdIterators = remainingDocIdIterators.size();
            if (numRemainingDocIdIterators == 0) {
                return bitmapDocIdIterator;
            }
            BlockDocIdIterator[] docIdIterators = new BlockDocIdIterator[numRemainingDocIdIterators + 1];
            docIdIterators[0] = bitmapDocIdIterator;
            for (int i = 0; i < numRemainingDocIdIterators; ++i) {
                docIdIterators[i + 1] = (BlockDocIdIterator)remainingDocIdIterators.get(i);
            }
            return new OrDocIdIterator(docIdIterators);
        }
        return new OrDocIdIterator(allDocIdIterators);
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        long numEntriesScannedInFilter = 0L;
        for (FilterBlockDocIdSet docIdSet : this._docIdSets) {
            numEntriesScannedInFilter += docIdSet.getNumEntriesScannedInFilter();
        }
        return numEntriesScannedInFilter;
    }
}

