/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.AcquireReleaseColumnsSegmentOperator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinMaxValueBasedSelectionOrderByCombineOperator
extends BaseCombineOperator<SelectionResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinMaxValueBasedSelectionOrderByCombineOperator.class);
    private static final String EXPLAIN_NAME = "COMBINE_SELECT_ORDERBY_MINMAX";
    private static final BaseResultsBlock EMPTY_RESULTS_BLOCK = new SelectionResultsBlock(new DataSchema(new String[0], new DataSchema.ColumnDataType[0]), Collections.emptyList());
    private final AtomicInteger _endOperatorId;
    private final int _numRowsToKeep;
    private final List<MinMaxValueContext> _minMaxValueContexts;
    private final AtomicReference<Comparable> _globalBoundaryValue = new AtomicReference();

    MinMaxValueBasedSelectionOrderByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(operators, queryContext, executorService);
        this._endOperatorId = new AtomicInteger(this._numOperators);
        this._numRowsToKeep = queryContext.getLimit() + queryContext.getOffset();
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        assert (orderByExpressions != null);
        int numOrderByExpressions = orderByExpressions.size();
        assert (numOrderByExpressions > 0);
        OrderByExpressionContext firstOrderByExpression = orderByExpressions.get(0);
        assert (firstOrderByExpression.getExpression().getType() == ExpressionContext.Type.IDENTIFIER);
        String firstOrderByColumn = firstOrderByExpression.getExpression().getIdentifier();
        this._minMaxValueContexts = new ArrayList<MinMaxValueContext>(this._numOperators);
        for (Operator operator : this._operators) {
            this._minMaxValueContexts.add(new MinMaxValueContext(operator, firstOrderByColumn));
        }
        if (firstOrderByExpression.isAsc()) {
            this._minMaxValueContexts.sort((o1, o2) -> {
                if (o1._minValue == null) {
                    return o2._minValue == null ? 0 : -1;
                }
                if (o2._minValue == null) {
                    return 1;
                }
                return o1._minValue.compareTo(o2._minValue);
            });
        } else {
            this._minMaxValueContexts.sort((o1, o2) -> {
                if (o1._maxValue == null) {
                    return o2._maxValue == null ? 0 : -1;
                }
                if (o2._maxValue == null) {
                    return 1;
                }
                return o2._maxValue.compareTo(o1._maxValue);
            });
        }
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments() {
        int operatorId;
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        assert (orderByExpressions != null);
        int numOrderByExpressions = orderByExpressions.size();
        assert (numOrderByExpressions > 0);
        OrderByExpressionContext firstOrderByExpression = orderByExpressions.get(0);
        assert (firstOrderByExpression.getExpression().getType() == ExpressionContext.Type.IDENTIFIER);
        boolean asc = firstOrderByExpression.isAsc();
        Comparable threadBoundaryValue = null;
        while ((operatorId = this._nextOperatorId.getAndIncrement()) < this._numOperators) {
            SelectionResultsBlock resultsBlock;
            if (operatorId >= this._endOperatorId.get()) {
                this._blockingQueue.offer(EMPTY_RESULTS_BLOCK);
                continue;
            }
            Comparable boundaryValue = this._globalBoundaryValue.get();
            if (boundaryValue == null) {
                boundaryValue = threadBoundaryValue;
            } else if (threadBoundaryValue != null) {
                if (asc) {
                    if (threadBoundaryValue.compareTo(boundaryValue) < 0) {
                        boundaryValue = threadBoundaryValue;
                    }
                } else if (threadBoundaryValue.compareTo(boundaryValue) > 0) {
                    boundaryValue = threadBoundaryValue;
                }
            }
            MinMaxValueContext minMaxValueContext = this._minMaxValueContexts.get(operatorId);
            if (boundaryValue != null) {
                int result;
                if (asc) {
                    if (minMaxValueContext._minValue != null && ((result = minMaxValueContext._minValue.compareTo(boundaryValue)) > 0 || result == 0 && numOrderByExpressions == 1)) {
                        this._endOperatorId.set(operatorId);
                        this._blockingQueue.offer(EMPTY_RESULTS_BLOCK);
                        continue;
                    }
                } else if (minMaxValueContext._maxValue != null && ((result = minMaxValueContext._maxValue.compareTo(boundaryValue)) < 0 || result == 0 && numOrderByExpressions == 1)) {
                    this._endOperatorId.set(operatorId);
                    this._blockingQueue.offer(EMPTY_RESULTS_BLOCK);
                    continue;
                }
            }
            Operator<BaseResultsBlock> operator = minMaxValueContext._operator;
            try {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).acquire();
                }
                resultsBlock = (SelectionResultsBlock)operator.nextBlock();
            }
            finally {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).release();
                }
            }
            Collection<Object[]> rows = resultsBlock.getRows();
            if (rows != null && rows.size() >= this._numRowsToKeep) {
                Comparable segmentBoundaryValue;
                if (rows instanceof PriorityQueue) {
                    assert (((PriorityQueue)rows).peek() != null);
                    segmentBoundaryValue = (Comparable)((Object[])((PriorityQueue)rows).peek())[0];
                } else {
                    assert (rows instanceof List);
                    segmentBoundaryValue = (Comparable)((Object[])((List)rows).get(rows.size() - 1))[0];
                }
                if (boundaryValue == null) {
                    boundaryValue = segmentBoundaryValue;
                } else if (asc) {
                    if (segmentBoundaryValue.compareTo(boundaryValue) < 0) {
                        boundaryValue = segmentBoundaryValue;
                    }
                } else if (segmentBoundaryValue.compareTo(boundaryValue) > 0) {
                    boundaryValue = segmentBoundaryValue;
                }
            }
            threadBoundaryValue = boundaryValue;
            this._blockingQueue.offer(resultsBlock);
        }
    }

    @Override
    protected BaseResultsBlock mergeResults() throws Exception {
        SelectionResultsBlock mergedBlock = null;
        int numBlocksMerged = 0;
        long endTimeMs = this._queryContext.getEndTimeMs();
        while (numBlocksMerged < this._numOperators) {
            BaseResultsBlock blockToMerge = (BaseResultsBlock)this._blockingQueue.poll(endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            if (blockToMerge == null) {
                LOGGER.error("Timed out while polling results block, numBlocksMerged: {} (query: {})", (Object)numBlocksMerged, (Object)this._queryContext);
                return new ExceptionResultsBlock((Throwable)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Throwable)new TimeoutException("Timed out while polling results block")));
            }
            if (blockToMerge == EMPTY_RESULTS_BLOCK) {
                ++numBlocksMerged;
                continue;
            }
            if (blockToMerge.getProcessingExceptions() != null) {
                return blockToMerge;
            }
            if (mergedBlock == null) {
                mergedBlock = this.convertToMergeableBlock((SelectionResultsBlock)blockToMerge);
            } else {
                this.mergeResultsBlocks(mergedBlock, (SelectionResultsBlock)blockToMerge);
            }
            ++numBlocksMerged;
            PriorityQueue<Object[]> selectionResult = mergedBlock.getRowsAsPriorityQueue();
            if (selectionResult == null || selectionResult.size() != this._numRowsToKeep) continue;
            assert (selectionResult.peek() != null);
            this._globalBoundaryValue.set((Comparable)selectionResult.peek()[0]);
        }
        return mergedBlock;
    }

    @Override
    protected void mergeResultsBlocks(SelectionResultsBlock mergedBlock, SelectionResultsBlock blockToMerge) {
        DataSchema mergedDataSchema = mergedBlock.getDataSchema();
        DataSchema dataSchemaToMerge = blockToMerge.getDataSchema();
        assert (mergedDataSchema != null && dataSchemaToMerge != null);
        if (!mergedDataSchema.equals((Object)dataSchemaToMerge)) {
            String errorMessage = String.format("Data schema mismatch between merged block: %s and block to merge: %s, drop block to merge", mergedDataSchema, dataSchemaToMerge);
            LOGGER.debug(errorMessage);
            mergedBlock.addToProcessingExceptions(QueryException.getException((ProcessingException)QueryException.MERGE_RESPONSE_ERROR, (String)errorMessage));
            return;
        }
        PriorityQueue<Object[]> mergedRows = mergedBlock.getRowsAsPriorityQueue();
        Collection<Object[]> rowsToMerge = blockToMerge.getRows();
        assert (mergedRows != null && rowsToMerge != null);
        SelectionOperatorUtils.mergeWithOrdering(mergedRows, rowsToMerge, this._numRowsToKeep);
    }

    @Override
    protected SelectionResultsBlock convertToMergeableBlock(SelectionResultsBlock resultsBlock) {
        return resultsBlock.convertToPriorityQueueBased();
    }

    private static class MinMaxValueContext {
        final Operator<BaseResultsBlock> _operator;
        final Comparable _minValue;
        final Comparable _maxValue;

        MinMaxValueContext(Operator<BaseResultsBlock> operator, String column) {
            this._operator = operator;
            DataSourceMetadata dataSourceMetadata = operator.getIndexSegment().getDataSource(column).getDataSourceMetadata();
            this._minValue = dataSourceMetadata.getMinValue();
            this._maxValue = dataSourceMetadata.getMaxValue();
        }
    }
}

