/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.results.DistinctResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;

public class DistinctCombineOperator
extends BaseCombineOperator<DistinctResultsBlock> {
    private static final String EXPLAIN_NAME = "COMBINE_DISTINCT";
    private final boolean _hasOrderBy;

    public DistinctCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(operators, queryContext, executorService);
        this._hasOrderBy = queryContext.getOrderByExpressions() != null;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected boolean isQuerySatisfied(DistinctResultsBlock resultsBlock) {
        if (this._hasOrderBy) {
            return false;
        }
        return resultsBlock.getDistinctTable().size() >= this._queryContext.getLimit();
    }

    @Override
    protected void mergeResultsBlocks(DistinctResultsBlock mergedBlock, DistinctResultsBlock blockToMerge) {
        DistinctTable mergedDistinctTable = mergedBlock.getDistinctTable();
        DistinctTable distinctTableToMerge = blockToMerge.getDistinctTable();
        assert (mergedDistinctTable != null && distinctTableToMerge != null);
        if (!mergedDistinctTable.isMainTable()) {
            DistinctTable mainDistinctTable = new DistinctTable(distinctTableToMerge.getDataSchema(), this._queryContext.getOrderByExpressions(), this._queryContext.getLimit(), this._queryContext.isNullHandlingEnabled());
            mainDistinctTable.mergeTable(mergedDistinctTable);
            mergedBlock.setDistinctTable(mainDistinctTable);
            mergedDistinctTable = mainDistinctTable;
        }
        mergedDistinctTable.mergeTable(distinctTableToMerge);
    }
}

