/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.AcquireReleaseColumnsSegmentOperator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.apache.pinot.spi.accounting.ThreadExecutionContext;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.apache.pinot.spi.exception.QueryCancelledException;
import org.apache.pinot.spi.trace.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCombineOperator<T extends BaseResultsBlock>
extends BaseOperator<BaseResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCombineOperator.class);
    protected final List<Operator> _operators;
    protected final int _numOperators;
    protected final QueryContext _queryContext;
    protected final ExecutorService _executorService;
    protected final int _numTasks;
    protected final Future[] _futures;
    protected final AtomicInteger _nextOperatorId = new AtomicInteger();
    protected final BlockingQueue<BaseResultsBlock> _blockingQueue = new LinkedBlockingQueue<BaseResultsBlock>();
    protected final AtomicLong _totalWorkerThreadCpuTimeNs = new AtomicLong(0L);

    protected BaseCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        this._operators = operators;
        this._numOperators = this._operators.size();
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._numTasks = CombineOperatorUtils.getNumTasksForQuery(operators.size(), queryContext.getMaxExecutionThreads());
        this._futures = new Future[this._numTasks];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BaseResultsBlock getNextBlock() {
        BaseResultsBlock mergedBlock;
        final Phaser phaser = new Phaser(1);
        Tracing.activeRecording().setNumTasks(this._numTasks);
        final ThreadExecutionContext parentContext = Tracing.getThreadAccountant().getThreadExecutionContext();
        for (int i = 0; i < this._numTasks; ++i) {
            final int taskId = i;
            this._futures[i] = this._executorService.submit(new TraceRunnable(){

                @Override
                public void runJob() {
                    ThreadResourceUsageProvider threadResourceUsageProvider = new ThreadResourceUsageProvider();
                    Tracing.ThreadAccountantOps.setupWorker((int)taskId, (ThreadResourceUsageProvider)threadResourceUsageProvider, (ThreadExecutionContext)parentContext);
                    if (phaser.register() < 0) {
                        Tracing.ThreadAccountantOps.clear();
                        return;
                    }
                    try {
                        BaseCombineOperator.this.processSegments();
                    }
                    catch (EarlyTerminationException earlyTerminationException) {
                    }
                    catch (Throwable t) {
                        if (t instanceof Exception) {
                            LOGGER.error("Caught exception while processing query: " + BaseCombineOperator.this._queryContext, t);
                        } else {
                            LOGGER.error("Caught serious error while processing query: " + BaseCombineOperator.this._queryContext, t);
                        }
                        BaseCombineOperator.this.onException(t);
                    }
                    finally {
                        BaseCombineOperator.this.onFinish();
                        phaser.arriveAndDeregister();
                        Tracing.ThreadAccountantOps.clear();
                    }
                    BaseCombineOperator.this._totalWorkerThreadCpuTimeNs.getAndAdd(threadResourceUsageProvider.getThreadTimeNs());
                }
            });
        }
        try {
            mergedBlock = this.mergeResults();
        }
        catch (InterruptedException | EarlyTerminationException e) {
            Exception killedErrorMsg = Tracing.getThreadAccountant().getErrorStatus();
            throw new QueryCancelledException("Cancelled while merging results blocks" + (String)(killedErrorMsg == null ? "" : " " + killedErrorMsg), e);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while merging results blocks (query: {})", (Object)this._queryContext, (Object)e);
            mergedBlock = new ExceptionResultsBlock((Throwable)QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Throwable)e));
        }
        finally {
            for (Future future : this._futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            phaser.awaitAdvance(phaser.arriveAndDeregister());
        }
        int numServerThreads = Math.min(this._numTasks, ResourceManager.DEFAULT_QUERY_WORKER_THREADS);
        CombineOperatorUtils.setExecutionStatistics(mergedBlock, this._operators, this._totalWorkerThreadCpuTimeNs.get(), numServerThreads);
        return mergedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSegments() {
        int operatorId;
        while ((operatorId = this._nextOperatorId.getAndIncrement()) < this._numOperators) {
            BaseResultsBlock resultsBlock;
            Operator operator = this._operators.get(operatorId);
            try {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).acquire();
                }
                resultsBlock = (BaseResultsBlock)operator.nextBlock();
            }
            finally {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).release();
                }
            }
            if (this.isQuerySatisfied(resultsBlock)) {
                this._blockingQueue.offer(resultsBlock);
                return;
            }
            this._blockingQueue.offer(resultsBlock);
        }
    }

    protected void onException(Throwable t) {
        this._blockingQueue.offer(new ExceptionResultsBlock(t));
    }

    protected void onFinish() {
    }

    protected BaseResultsBlock mergeResults() throws Exception {
        BaseResultsBlock mergedBlock = null;
        long endTimeMs = this._queryContext.getEndTimeMs();
        for (int numBlocksMerged = 0; numBlocksMerged < this._numOperators; ++numBlocksMerged) {
            long waitTimeMs = endTimeMs - System.currentTimeMillis();
            if (waitTimeMs <= 0L) {
                return this.getTimeoutResultsBlock(numBlocksMerged);
            }
            BaseResultsBlock blockToMerge = this._blockingQueue.poll(waitTimeMs, TimeUnit.MILLISECONDS);
            if (blockToMerge == null) {
                return this.getTimeoutResultsBlock(numBlocksMerged);
            }
            if (blockToMerge.getProcessingExceptions() != null) {
                return blockToMerge;
            }
            if (mergedBlock == null) {
                mergedBlock = this.convertToMergeableBlock(blockToMerge);
                continue;
            }
            this.mergeResultsBlocks(mergedBlock, blockToMerge);
            if (!this.isQuerySatisfied(mergedBlock)) continue;
            return mergedBlock;
        }
        return mergedBlock;
    }

    private ExceptionResultsBlock getTimeoutResultsBlock(int numBlocksMerged) {
        LOGGER.error("Timed out while polling results block, numBlocksMerged: {} (query: {})", (Object)numBlocksMerged, (Object)this._queryContext);
        return new ExceptionResultsBlock(QueryException.EXECUTION_TIMEOUT_ERROR, new TimeoutException("Timed out while polling results block"));
    }

    protected boolean isQuerySatisfied(T resultsBlock) {
        return false;
    }

    protected abstract void mergeResultsBlocks(T var1, T var2);

    protected T convertToMergeableBlock(T resultsBlock) {
        return resultsBlock;
    }

    @Override
    public List<Operator> getChildOperators() {
        return this._operators;
    }
}

