/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;

public class AggregationCombineOperator
extends BaseCombineOperator<AggregationResultsBlock> {
    private static final String EXPLAIN_NAME = "COMBINE_AGGREGATE";

    public AggregationCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(operators, queryContext, executorService);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected void mergeResultsBlocks(AggregationResultsBlock mergedBlock, AggregationResultsBlock blockToMerge) {
        AggregationFunction[] aggregationFunctions = mergedBlock.getAggregationFunctions();
        List<Object> mergedResults = mergedBlock.getResults();
        List<Object> resultsToMerge = blockToMerge.getResults();
        assert (aggregationFunctions != null && mergedResults != null && resultsToMerge != null);
        int numAggregationFunctions = aggregationFunctions.length;
        for (int i = 0; i < numAggregationFunctions; ++i) {
            mergedResults.set(i, aggregationFunctions[i].merge(mergedResults.get(i), resultsToMerge.get(i)));
        }
    }
}

