/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;

public class SelectionResultsBlock
extends BaseResultsBlock {
    private final DataSchema _dataSchema;
    private final Collection<Object[]> _rows;
    private final Comparator<? super Object[]> _comparator;

    public SelectionResultsBlock(DataSchema dataSchema, List<Object[]> rows) {
        this(dataSchema, rows, null);
    }

    public SelectionResultsBlock(DataSchema dataSchema, PriorityQueue<Object[]> rows) {
        this(dataSchema, rows, rows.comparator());
    }

    public SelectionResultsBlock(DataSchema dataSchema, Collection<Object[]> rows, @Nullable Comparator<? super Object[]> comparator) {
        this._dataSchema = dataSchema;
        this._rows = rows;
        this._comparator = comparator;
    }

    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public Collection<Object[]> getRows() {
        return this._rows;
    }

    @Override
    public int getNumRows() {
        return this._rows.size();
    }

    @Override
    public DataSchema getDataSchema(QueryContext queryContext) {
        return this._dataSchema;
    }

    @Override
    public Collection<Object[]> getRows(QueryContext queryContext) {
        return this._rows;
    }

    public SelectionResultsBlock convertToPriorityQueueBased() {
        if (this._rows instanceof PriorityQueue) {
            return this;
        }
        Preconditions.checkState((this._comparator != null ? 1 : 0) != 0, (Object)"No comparator specified in the results block");
        PriorityQueue<Object[]> result = new PriorityQueue<Object[]>(this._comparator);
        result.addAll(this._rows);
        return new SelectionResultsBlock(this._dataSchema, result);
    }

    public PriorityQueue<Object[]> getRowsAsPriorityQueue() {
        Preconditions.checkState((boolean)(this._rows instanceof PriorityQueue), (Object)"The results block is not backed by a priority queue");
        return (PriorityQueue)this._rows;
    }

    @Override
    public DataTable getDataTable(QueryContext queryContext) throws IOException {
        return SelectionOperatorUtils.getDataTableFromRows(this._rows, this._dataSchema, queryContext.isNullHandlingEnabled());
    }
}

