/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.DistinctResultsBlock;
import org.apache.pinot.core.operator.blocks.results.GroupByResultsBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;

public class ResultsBlockUtils {
    private ResultsBlockUtils() {
    }

    public static BaseResultsBlock buildEmptyQueryResults(QueryContext queryContext) {
        if (QueryContextUtils.isSelectionQuery(queryContext)) {
            return ResultsBlockUtils.buildEmptySelectionQueryResults(queryContext);
        }
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            if (queryContext.getGroupByExpressions() == null) {
                return ResultsBlockUtils.buildEmptyAggregationQueryResults(queryContext);
            }
            return ResultsBlockUtils.buildEmptyGroupByQueryResults(queryContext);
        }
        assert (QueryContextUtils.isDistinctQuery(queryContext));
        return ResultsBlockUtils.buildEmptyDistinctQueryResults(queryContext);
    }

    private static SelectionResultsBlock buildEmptySelectionQueryResults(QueryContext queryContext) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        String[] columnNames = new String[numSelectExpressions];
        for (int i = 0; i < numSelectExpressions; ++i) {
            columnNames[i] = selectExpressions.get(i).toString();
        }
        Object[] columnDataTypes = new DataSchema.ColumnDataType[numSelectExpressions];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        DataSchema dataSchema = new DataSchema(columnNames, (DataSchema.ColumnDataType[])columnDataTypes);
        return new SelectionResultsBlock(dataSchema, Collections.emptyList());
    }

    private static AggregationResultsBlock buildEmptyAggregationQueryResults(QueryContext queryContext) {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        int numAggregations = aggregationFunctions.length;
        ArrayList<Object> results = new ArrayList<Object>(numAggregations);
        for (AggregationFunction aggregationFunction : aggregationFunctions) {
            results.add(aggregationFunction.extractAggregationResult(aggregationFunction.createAggregationResultHolder()));
        }
        return new AggregationResultsBlock(aggregationFunctions, results);
    }

    private static GroupByResultsBlock buildEmptyGroupByQueryResults(QueryContext queryContext) {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        int numAggregations = aggregationFunctions.length;
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        assert (groupByExpressions != null);
        int numColumns = groupByExpressions.size() + numAggregations;
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        int index = 0;
        for (ExpressionContext groupByExpression : groupByExpressions) {
            columnNames[index] = groupByExpression.toString();
            columnDataTypes[index] = DataSchema.ColumnDataType.STRING;
            ++index;
        }
        for (AggregationFunction aggregationFunction : aggregationFunctions) {
            columnNames[index] = aggregationFunction.getResultColumnName();
            columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
            ++index;
        }
        return new GroupByResultsBlock(new DataSchema(columnNames, columnDataTypes));
    }

    private static DistinctResultsBlock buildEmptyDistinctQueryResults(QueryContext queryContext) {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0] instanceof DistinctAggregationFunction);
        DistinctAggregationFunction distinctAggregationFunction = (DistinctAggregationFunction)aggregationFunctions[0];
        String[] columnNames = distinctAggregationFunction.getColumns();
        Object[] columnDataTypes = new DataSchema.ColumnDataType[columnNames.length];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        DistinctTable distinctTable = new DistinctTable(new DataSchema(columnNames, (DataSchema.ColumnDataType[])columnDataTypes), Collections.emptySet(), queryContext.isNullHandlingEnabled());
        return new DistinctResultsBlock(distinctAggregationFunction, distinctTable);
    }
}

