/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;

public class DistinctResultsBlock
extends BaseResultsBlock {
    private final DistinctAggregationFunction _distinctFunction;
    private DistinctTable _distinctTable;

    public DistinctResultsBlock(DistinctAggregationFunction distinctFunction, DistinctTable distinctTable) {
        this._distinctFunction = distinctFunction;
        this._distinctTable = distinctTable;
    }

    public DistinctTable getDistinctTable() {
        return this._distinctTable;
    }

    public void setDistinctTable(DistinctTable distinctTable) {
        this._distinctTable = distinctTable;
    }

    @Override
    public int getNumRows() {
        return this._distinctTable.size();
    }

    @Override
    public DataSchema getDataSchema(QueryContext queryContext) {
        return this._distinctTable.getDataSchema();
    }

    @Override
    public Collection<Object[]> getRows(QueryContext queryContext) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this._distinctTable.size());
        for (Record record : this._distinctTable.getRecords()) {
            rows.add(record.getValues());
        }
        return rows;
    }

    @Override
    public DataTable getDataTable(QueryContext queryContext) throws IOException {
        Collection<Object[]> rows = this.getRows(queryContext);
        return SelectionOperatorUtils.getDataTableFromRows(rows, this._distinctTable.getDataSchema(), queryContext.isNullHandlingEnabled());
    }
}

