/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.BlockDocIdValueSet;
import org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.request.context.QueryContext;

public class InstanceResponseBlock
implements Block {
    private final BaseResultsBlock _resultsBlock;
    private final QueryContext _queryContext;
    private final Map<Integer, String> _exceptions;
    private final Map<String, String> _metadata;

    public InstanceResponseBlock(BaseResultsBlock resultsBlock, QueryContext queryContext) {
        this._resultsBlock = resultsBlock;
        this._queryContext = queryContext;
        this._exceptions = new HashMap<Integer, String>();
        List<ProcessingException> processingExceptions = resultsBlock.getProcessingExceptions();
        if (processingExceptions != null) {
            for (ProcessingException processingException : processingExceptions) {
                this._exceptions.put(processingException.getErrorCode(), processingException.getMessage());
            }
        }
        this._metadata = resultsBlock.getResultsMetadata();
    }

    public InstanceResponseBlock() {
        this._resultsBlock = null;
        this._queryContext = null;
        this._exceptions = new HashMap<Integer, String>();
        this._metadata = new HashMap<String, String>();
    }

    private InstanceResponseBlock(Map<Integer, String> exceptions, Map<String, String> metadata) {
        this._resultsBlock = null;
        this._queryContext = null;
        this._exceptions = exceptions;
        this._metadata = metadata;
    }

    public InstanceResponseBlock toMetadataOnlyResponseBlock() {
        return new InstanceResponseBlock(this._exceptions, this._metadata);
    }

    public void addException(ProcessingException processingException) {
        this._exceptions.put(processingException.getErrorCode(), processingException.getMessage());
    }

    public void addException(int errorCode, String exceptionMessage) {
        this._exceptions.put(errorCode, exceptionMessage);
    }

    public void addMetadata(String key, String value) {
        this._metadata.put(key, value);
    }

    @Nullable
    public BaseResultsBlock getResultsBlock() {
        return this._resultsBlock;
    }

    @Nullable
    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    public Map<Integer, String> getExceptions() {
        return this._exceptions;
    }

    public Map<String, String> getResponseMetadata() {
        return this._metadata;
    }

    @Nullable
    public DataSchema getDataSchema() {
        return this._resultsBlock != null ? this._resultsBlock.getDataSchema(this._queryContext) : null;
    }

    @Nullable
    public Collection<Object[]> getRows() {
        return this._resultsBlock != null ? this._resultsBlock.getRows(this._queryContext) : null;
    }

    public DataTable toDataTable() throws IOException {
        DataTable dataTable = this.toDataOnlyDataTable();
        this.attachMetadata(dataTable);
        return dataTable;
    }

    public DataTable toDataOnlyDataTable() throws IOException {
        return this._resultsBlock != null ? this._resultsBlock.getDataTable(this._queryContext) : DataTableBuilderFactory.getEmptyDataTable();
    }

    public DataTable toMetadataOnlyDataTable() {
        DataTable dataTable = DataTableBuilderFactory.getEmptyDataTable();
        this.attachMetadata(dataTable);
        return dataTable;
    }

    private void attachMetadata(DataTable dataTable) {
        for (Map.Entry<Integer, String> entry : this._exceptions.entrySet()) {
            dataTable.addException(entry.getKey().intValue(), entry.getValue());
        }
        dataTable.getMetadata().putAll(this._metadata);
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

