/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPurger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPurger.class);
    private final File _indexDir;
    private final File _workingDir;
    private final TableConfig _tableConfig;
    private final RecordPurger _recordPurger;
    private final RecordModifier _recordModifier;
    private int _numRecordsPurged;
    private int _numRecordsModified;

    public SegmentPurger(File indexDir, File workingDir, TableConfig tableConfig, @Nullable RecordPurger recordPurger, @Nullable RecordModifier recordModifier) {
        Preconditions.checkArgument((recordPurger != null || recordModifier != null ? 1 : 0) != 0, (Object)"At least one of record purger and modifier should be non-null");
        this._indexDir = indexDir;
        this._workingDir = workingDir;
        this._tableConfig = tableConfig;
        this._recordPurger = recordPurger;
        this._recordModifier = recordModifier;
    }

    public File purgeSegment() throws Exception {
        SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(this._indexDir);
        String segmentName = segmentMetadata.getName();
        LOGGER.info("Start purging table: {}, segment: {}", (Object)this._tableConfig.getTableName(), (Object)segmentName);
        try (PurgeRecordReader purgeRecordReader = new PurgeRecordReader();){
            while (purgeRecordReader.hasNext()) {
                purgeRecordReader.next();
            }
            if (this._numRecordsModified == 0 && this._numRecordsPurged == 0) {
                File file = null;
                return file;
            }
            SegmentGeneratorConfig config = new SegmentGeneratorConfig(this._tableConfig, segmentMetadata.getSchema());
            config.setOutDir(this._workingDir.getPath());
            config.setSegmentName(segmentName);
            config.setCreationTime(String.valueOf(segmentMetadata.getIndexCreationTime()));
            if (segmentMetadata.getTimeInterval() != null) {
                config.setTimeColumnName(this._tableConfig.getValidationConfig().getTimeColumnName());
                config.setStartTime(Long.toString(segmentMetadata.getStartTime()));
                config.setEndTime(Long.toString(segmentMetadata.getEndTime()));
                config.setSegmentTimeUnit(segmentMetadata.getTimeUnit());
            }
            SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
            purgeRecordReader.rewind();
            driver.init(config, (RecordReader)purgeRecordReader);
            driver.build();
        }
        LOGGER.info("Finish purging table: {}, segment: {}, purged {} records, modified {} records", new Object[]{this._tableConfig.getTableName(), segmentName, this._numRecordsPurged, this._numRecordsModified});
        return new File(this._workingDir, segmentName);
    }

    public RecordPurger getRecordPurger() {
        return this._recordPurger;
    }

    public RecordModifier getRecordModifier() {
        return this._recordModifier;
    }

    public int getNumRecordsPurged() {
        return this._numRecordsPurged;
    }

    public int getNumRecordsModified() {
        return this._numRecordsModified;
    }

    public static interface RecordModifier {
        public boolean modifyRecord(GenericRow var1);
    }

    public static interface RecordModifierFactory {
        public RecordModifier getRecordModifier(String var1);
    }

    public static interface RecordPurger {
        public boolean shouldPurge(GenericRow var1);
    }

    public static interface RecordPurgerFactory {
        public RecordPurger getRecordPurger(String var1);
    }

    private class PurgeRecordReader
    implements RecordReader {
        final PinotSegmentRecordReader _pinotSegmentRecordReader;
        GenericRow _nextRow = new GenericRow();
        boolean _nextRowReturned = true;
        boolean _finished = false;

        PurgeRecordReader() throws Exception {
            this._pinotSegmentRecordReader = new PinotSegmentRecordReader(SegmentPurger.this._indexDir);
        }

        public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
        }

        public boolean hasNext() {
            if (SegmentPurger.this._recordPurger == null) {
                return this._pinotSegmentRecordReader.hasNext();
            }
            if (this._finished) {
                return false;
            }
            if (!this._nextRowReturned) {
                return true;
            }
            while (this._pinotSegmentRecordReader.hasNext()) {
                this._nextRow.clear();
                this._nextRow = this._pinotSegmentRecordReader.next(this._nextRow);
                if (SegmentPurger.this._recordPurger.shouldPurge(this._nextRow)) {
                    ++SegmentPurger.this._numRecordsPurged;
                    continue;
                }
                this._nextRowReturned = false;
                return true;
            }
            this._finished = true;
            return false;
        }

        public GenericRow next() {
            return this.next(new GenericRow());
        }

        public GenericRow next(GenericRow reuse) {
            if (SegmentPurger.this._recordPurger == null) {
                reuse = this._pinotSegmentRecordReader.next(reuse);
            } else {
                Preconditions.checkState((!this._nextRowReturned ? 1 : 0) != 0);
                reuse.init(this._nextRow);
                this._nextRowReturned = true;
            }
            if (SegmentPurger.this._recordModifier != null && SegmentPurger.this._recordModifier.modifyRecord(reuse)) {
                ++SegmentPurger.this._numRecordsModified;
            }
            return reuse;
        }

        public void rewind() {
            this._pinotSegmentRecordReader.rewind();
            this._nextRowReturned = true;
            this._finished = false;
            SegmentPurger.this._numRecordsPurged = 0;
            SegmentPurger.this._numRecordsModified = 0;
        }

        public void close() throws IOException {
            this._pinotSegmentRecordReader.close();
        }
    }
}

