/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.table;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.request.context.QueryContext;

public class ConcurrentIndexedTable
extends IndexedTable {
    private final AtomicBoolean _noMoreNewRecords = new AtomicBoolean();
    private final ReentrantReadWriteLock _readWriteLock = new ReentrantReadWriteLock();

    public ConcurrentIndexedTable(DataSchema dataSchema, QueryContext queryContext, int resultSize, int trimSize, int trimThreshold) {
        super(dataSchema, queryContext, resultSize, trimSize, trimThreshold, new ConcurrentHashMap<Key, Record>());
    }

    @Override
    public boolean upsert(Key key, Record record) {
        if (this._hasOrderBy) {
            this.upsertWithOrderBy(key, record);
        } else {
            this.upsertWithoutOrderBy(key, record);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upsertWithOrderBy(Key key, Record record) {
        this._readWriteLock.readLock().lock();
        try {
            this.addOrUpdateRecord(key, record);
        }
        finally {
            this._readWriteLock.readLock().unlock();
        }
        if (this._lookupMap.size() >= this._trimThreshold) {
            this._readWriteLock.writeLock().lock();
            try {
                if (this._lookupMap.size() >= this._trimThreshold) {
                    this.resize();
                }
            }
            finally {
                this._readWriteLock.writeLock().unlock();
            }
        }
    }

    protected void upsertWithoutOrderBy(Key key, Record record) {
        if (this._noMoreNewRecords.get()) {
            this.updateExistingRecord(key, record);
        } else {
            this.addOrUpdateRecord(key, record);
            if (this._lookupMap.size() >= this._resultSize) {
                this._noMoreNewRecords.set(true);
            }
        }
    }
}

