/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import java.net.URI;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.core.data.manager.realtime.LLRealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.slf4j.Logger;

public class SplitSegmentCommitter
implements SegmentCommitter {
    private final SegmentCompletionProtocol.Request.Params _params;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final SegmentUploader _segmentUploader;
    private final Logger _segmentLogger;

    public SplitSegmentCommitter(Logger segmentLogger, ServerSegmentCompletionProtocolHandler protocolHandler, SegmentCompletionProtocol.Request.Params params, SegmentUploader segmentUploader) {
        this._segmentLogger = segmentLogger;
        this._protocolHandler = protocolHandler;
        this._params = new SegmentCompletionProtocol.Request.Params(params);
        this._segmentUploader = segmentUploader;
    }

    @Override
    public SegmentCompletionProtocol.Response commit(LLRealtimeSegmentDataManager.SegmentBuildDescriptor segmentBuildDescriptor) {
        File segmentTarFile = segmentBuildDescriptor.getSegmentTarFile();
        SegmentCompletionProtocol.Response segmentCommitStartResponse = this._protocolHandler.segmentCommitStart(this._params);
        if (!segmentCommitStartResponse.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_CONTINUE)) {
            this._segmentLogger.warn("CommitStart failed  with response {}", (Object)segmentCommitStartResponse.toJsonString());
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        String segmentLocation = this.uploadSegment(segmentTarFile, this._segmentUploader, this._params);
        if (segmentLocation == null) {
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        this._params.withSegmentLocation(segmentLocation);
        SegmentCompletionProtocol.Response commitEndResponse = this._protocolHandler.segmentCommitEndWithMetadata(this._params, segmentBuildDescriptor.getMetadataFiles());
        if (!commitEndResponse.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS)) {
            this._segmentLogger.warn("CommitEnd failed with response {}", (Object)commitEndResponse.toJsonString());
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        return commitEndResponse;
    }

    protected String uploadSegment(File segmentTarFile, SegmentUploader segmentUploader, SegmentCompletionProtocol.Request.Params params) {
        URI segmentLocation = segmentUploader.uploadSegment(segmentTarFile, new LLCSegmentName(params.getSegmentName()));
        if (segmentLocation != null) {
            return segmentLocation.toString();
        }
        return null;
    }
}

