/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.util.Map;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.io.writer.impl.DirectMemoryManager;
import org.apache.pinot.segment.local.io.writer.impl.MmapMemoryManager;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.stream.ConsumerPartitionState;
import org.apache.pinot.spi.stream.PartitionLagState;
import org.apache.pinot.spi.utils.CommonConstants;

public abstract class RealtimeSegmentDataManager
extends SegmentDataManager {
    public abstract MutableSegment getSegment();

    protected static PinotDataBufferMemoryManager getMemoryManager(String consumerDir, String segmentName, boolean offHeap, boolean directOffHeap, ServerMetrics serverMetrics) {
        if (offHeap && !directOffHeap) {
            return new MmapMemoryManager(consumerDir, segmentName, serverMetrics);
        }
        return new DirectMemoryManager(segmentName, serverMetrics);
    }

    public abstract Map<String, String> getPartitionToCurrentOffset();

    public abstract CommonConstants.ConsumerState getConsumerState();

    public abstract long getLastConsumedTimestamp();

    public abstract Map<String, ConsumerPartitionState> getConsumerPartitionState();

    public abstract Map<String, PartitionLagState> getPartitionToLagState(Map<String, ConsumerPartitionState> var1);
}

