/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.offline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.core.data.manager.offline.DimensionTable;
import org.apache.pinot.core.data.manager.offline.FastLookupDimensionTable;
import org.apache.pinot.core.data.manager.offline.LookupRecordLocation;
import org.apache.pinot.core.data.manager.offline.MemoryOptimizedDimensionTable;
import org.apache.pinot.core.data.manager.offline.OfflineTableDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.config.table.DimensionTableConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;

@ThreadSafe
public class DimensionTableDataManager
extends OfflineTableDataManager {
    private static final Map<String, DimensionTableDataManager> INSTANCES = new ConcurrentHashMap<String, DimensionTableDataManager>();
    private static final AtomicReferenceFieldUpdater<DimensionTableDataManager, DimensionTable> UPDATER = AtomicReferenceFieldUpdater.newUpdater(DimensionTableDataManager.class, DimensionTable.class, "_dimensionTable");
    private volatile DimensionTable _dimensionTable;
    private boolean _disablePreload = false;

    private DimensionTableDataManager() {
    }

    public static DimensionTableDataManager createInstanceByTableName(String tableNameWithType) {
        return INSTANCES.computeIfAbsent(tableNameWithType, k -> new DimensionTableDataManager());
    }

    @VisibleForTesting
    public static DimensionTableDataManager registerDimensionTable(String tableNameWithType, DimensionTableDataManager instance) {
        return INSTANCES.computeIfAbsent(tableNameWithType, k -> instance);
    }

    public static DimensionTableDataManager getInstanceByTableName(String tableNameWithType) {
        return INSTANCES.get(tableNameWithType);
    }

    @Override
    protected void doInit() {
        DimensionTableConfig dimensionTableConfig;
        super.doInit();
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for dimension table: %s", (Object)this._tableNameWithType);
        List primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)primaryKeyColumns), (String)"Primary key columns must be configured for dimension table: %s", (Object)this._tableNameWithType);
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        if (tableConfig != null && (dimensionTableConfig = tableConfig.getDimensionTableConfig()) != null) {
            this._disablePreload = dimensionTableConfig.isDisablePreload();
        }
        this._dimensionTable = this._disablePreload ? new MemoryOptimizedDimensionTable(schema, primaryKeyColumns, Collections.emptyMap(), Collections.emptyList(), this) : new FastLookupDimensionTable(schema, primaryKeyColumns, new HashMap<PrimaryKey, GenericRow>());
    }

    @Override
    public void addSegment(ImmutableSegment immutableSegment) {
        super.addSegment(immutableSegment);
        String segmentName = immutableSegment.getSegmentName();
        try {
            this.loadLookupTable();
            this._logger.info("Successfully loaded lookup table: {} after adding segment: {}", (Object)this._tableNameWithType, (Object)segmentName);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while loading lookup table: %s after adding segment: %s", this._tableNameWithType, segmentName), e);
        }
    }

    @Override
    public void removeSegment(String segmentName) {
        super.removeSegment(segmentName);
        try {
            this.loadLookupTable();
            this._logger.info("Successfully loaded lookup table: {} after removing segment: {}", (Object)this._tableNameWithType, (Object)segmentName);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while loading lookup table: %s after removing segment: %s", this._tableNameWithType, segmentName), e);
        }
    }

    @Override
    protected void doShutdown() {
        this.closeDimensionTable(this._dimensionTable);
    }

    private void closeDimensionTable(DimensionTable dimensionTable) {
        try {
            dimensionTable.close();
        }
        catch (Exception e) {
            this._logger.warn("Cannot close dimension table: {}", (Object)this._tableNameWithType, (Object)e);
        }
    }

    private void loadLookupTable() {
        DimensionTable replacement;
        DimensionTable snapshot;
        while (!UPDATER.compareAndSet(this, snapshot = this._dimensionTable, replacement = this._disablePreload ? this.createMemOptimisedDimensionTable() : this.createFastLookupDimensionTable())) {
        }
        this.closeDimensionTable(snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimensionTable createFastLookupDimensionTable() {
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for dimension table: %s", (Object)this._tableNameWithType);
        List primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)primaryKeyColumns), (String)"Primary key columns must be configured for dimension table: %s", (Object)this._tableNameWithType);
        HashMap<PrimaryKey, GenericRow> lookupTable = new HashMap<PrimaryKey, GenericRow>();
        List<SegmentDataManager> segmentDataManagers = this.acquireAllSegments();
        try {
            for (SegmentDataManager segmentManager : segmentDataManagers) {
                IndexSegment indexSegment = segmentManager.getSegment();
                int numTotalDocs = indexSegment.getSegmentMetadata().getTotalDocs();
                if (numTotalDocs <= 0) continue;
                try (PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();){
                    recordReader.init(indexSegment);
                    for (int i = 0; i < numTotalDocs; ++i) {
                        GenericRow row = new GenericRow();
                        recordReader.getRecord(i, row);
                        lookupTable.put(row.getPrimaryKey(primaryKeyColumns), row);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Caught exception while reading records from segment: " + indexSegment.getSegmentName());
                }
            }
            FastLookupDimensionTable fastLookupDimensionTable = new FastLookupDimensionTable(schema, primaryKeyColumns, lookupTable);
            return fastLookupDimensionTable;
        }
        finally {
            for (SegmentDataManager segmentManager : segmentDataManagers) {
                this.releaseSegment(segmentManager);
            }
        }
    }

    private DimensionTable createMemOptimisedDimensionTable() {
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for dimension table: %s", (Object)this._tableNameWithType);
        List primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)primaryKeyColumns), (String)"Primary key columns must be configured for dimension table: %s", (Object)this._tableNameWithType);
        HashMap<PrimaryKey, LookupRecordLocation> lookupTable = new HashMap<PrimaryKey, LookupRecordLocation>();
        List<SegmentDataManager> segmentDataManagers = this.acquireAllSegments();
        for (SegmentDataManager segmentManager : segmentDataManagers) {
            IndexSegment indexSegment = segmentManager.getSegment();
            int numTotalDocs = indexSegment.getSegmentMetadata().getTotalDocs();
            if (numTotalDocs <= 0) continue;
            try {
                PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();
                recordReader.init(indexSegment);
                for (int i = 0; i < numTotalDocs; ++i) {
                    GenericRow row = new GenericRow();
                    recordReader.getRecord(i, row);
                    lookupTable.put(row.getPrimaryKey(primaryKeyColumns), new LookupRecordLocation(recordReader, i));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while reading records from segment: " + indexSegment.getSegmentName());
            }
        }
        return new MemoryOptimizedDimensionTable(schema, primaryKeyColumns, lookupTable, segmentDataManagers, this);
    }

    public boolean isPopulated() {
        return !this._dimensionTable.isEmpty();
    }

    public GenericRow lookupRowByPrimaryKey(PrimaryKey pk) {
        return this._dimensionTable.get(pk);
    }

    public FieldSpec getColumnFieldSpec(String columnName) {
        return this._dimensionTable.getFieldSpecFor(columnName);
    }

    public List<String> getPrimaryKeyColumns() {
        return this._dimensionTable.getPrimaryKeyColumns();
    }
}

