/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableImplV2;
import org.apache.pinot.common.datatable.DataTableImplV3;
import org.apache.pinot.common.datatable.DataTableImplV4;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderV2V3;
import org.apache.pinot.core.common.datatable.DataTableBuilderV4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTableBuilderFactory.class);
    public static final int DEFAULT_VERSION = 3;
    private static int _version = 3;

    private DataTableBuilderFactory() {
    }

    public static int getDataTableVersion() {
        return _version;
    }

    public static void setDataTableVersion(int version) {
        LOGGER.info("Setting DataTable version to: " + version);
        if (version != 2 && version != 3 && version != 4) {
            throw new IllegalArgumentException("Unsupported version: " + version);
        }
        _version = version;
    }

    public static DataTableBuilder getDataTableBuilder(DataSchema dataSchema) {
        switch (_version) {
            case 2: 
            case 3: {
                return new DataTableBuilderV2V3(dataSchema, _version);
            }
            case 4: {
                return new DataTableBuilderV4(dataSchema);
            }
        }
        throw new IllegalStateException("Unsupported data table version: " + _version);
    }

    public static DataTable getEmptyDataTable() {
        switch (_version) {
            case 2: {
                return new DataTableImplV2();
            }
            case 3: {
                return new DataTableImplV3();
            }
            case 4: {
                return new DataTableImplV4();
            }
        }
        throw new IllegalStateException("Unsupported data table version: " + _version);
    }
}

