/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTableUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public abstract class BaseDataTableBuilder
implements DataTableBuilder {
    protected final DataSchema _dataSchema;
    protected final int _version;
    protected final int[] _columnOffsets;
    protected final int _rowSizeInBytes;
    protected final ByteArrayOutputStream _fixedSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    protected final DataOutputStream _fixedSizeDataOutputStream = new DataOutputStream(this._fixedSizeDataByteArrayOutputStream);
    protected final ByteArrayOutputStream _variableSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    protected final DataOutputStream _variableSizeDataOutputStream = new DataOutputStream(this._variableSizeDataByteArrayOutputStream);
    protected int _numRows;
    protected ByteBuffer _currentRowDataByteBuffer;

    public BaseDataTableBuilder(DataSchema dataSchema, int version) {
        this._dataSchema = dataSchema;
        this._version = version;
        this._columnOffsets = new int[dataSchema.size()];
        this._rowSizeInBytes = DataTableUtils.computeColumnOffsets((DataSchema)dataSchema, (int[])this._columnOffsets, (int)this._version);
    }

    @Override
    public void startRow() {
        ++this._numRows;
        this._currentRowDataByteBuffer = ByteBuffer.allocate(this._rowSizeInBytes);
    }

    @Override
    public void setColumn(int colId, int value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(value);
    }

    @Override
    public void setColumn(int colId, long value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putLong(value);
    }

    @Override
    public void setColumn(int colId, float value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putFloat(value);
    }

    @Override
    public void setColumn(int colId, double value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putDouble(value);
    }

    @Override
    public void setColumn(int colId, BigDecimal value) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        byte[] bytes = BigDecimalUtils.serialize((BigDecimal)value);
        this._currentRowDataByteBuffer.putInt(bytes.length);
        this._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    @Override
    public void setColumn(int colId, @Nullable Object value) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        if (value == null) {
            this._currentRowDataByteBuffer.putInt(0);
            this._variableSizeDataOutputStream.writeInt(100);
        } else {
            int objectTypeValue = ObjectSerDeUtils.ObjectType.getObjectType(value).getValue();
            byte[] bytes = ObjectSerDeUtils.serialize(value, objectTypeValue);
            this._currentRowDataByteBuffer.putInt(bytes.length);
            this._variableSizeDataOutputStream.writeInt(objectTypeValue);
            this._variableSizeDataByteArrayOutputStream.write(bytes);
        }
    }

    @Override
    public void setColumn(int colId, int[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (int value : values) {
            this._variableSizeDataOutputStream.writeInt(value);
        }
    }

    @Override
    public void setColumn(int colId, long[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (long value : values) {
            this._variableSizeDataOutputStream.writeLong(value);
        }
    }

    @Override
    public void setColumn(int colId, float[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (float value : values) {
            this._variableSizeDataOutputStream.writeFloat(value);
        }
    }

    @Override
    public void setColumn(int colId, double[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (double value : values) {
            this._variableSizeDataOutputStream.writeDouble(value);
        }
    }

    @Override
    public void finishRow() throws IOException {
        this._fixedSizeDataByteArrayOutputStream.write(this._currentRowDataByteBuffer.array());
    }
}

