/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datablock;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.ColumnarDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.datablock.RowDataBlock;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.spi.utils.ArrayCopyUtils;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class DataBlockBuilder {
    private final DataSchema _dataSchema;
    private final DataBlock.Type _blockType;
    private final DataSchema.ColumnDataType[] _columnDataTypes;
    private int[] _columnOffsets;
    private int _rowSizeInBytes;
    private int[] _cumulativeColumnOffsetSizeInBytes;
    private int[] _columnSizeInBytes;
    private int _numRows;
    private int _numColumns;
    private final Object2IntOpenHashMap<String> _dictionary = new Object2IntOpenHashMap();
    private final ByteArrayOutputStream _fixedSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream _fixedSizeDataOutputStream = new DataOutputStream(this._fixedSizeDataByteArrayOutputStream);
    private final ByteArrayOutputStream _variableSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream _variableSizeDataOutputStream = new DataOutputStream(this._variableSizeDataByteArrayOutputStream);

    private DataBlockBuilder(DataSchema dataSchema, DataBlock.Type blockType) {
        this._dataSchema = dataSchema;
        this._columnDataTypes = dataSchema.getColumnDataTypes();
        this._blockType = blockType;
        this._numColumns = dataSchema.size();
        if (this._blockType == DataBlock.Type.COLUMNAR) {
            this._cumulativeColumnOffsetSizeInBytes = new int[this._numColumns];
            this._columnSizeInBytes = new int[this._numColumns];
            DataBlockUtils.computeColumnSizeInBytes((DataSchema)this._dataSchema, (int[])this._columnSizeInBytes);
            int cumulativeColumnOffset = 0;
            for (int i = 0; i < this._numColumns; ++i) {
                this._cumulativeColumnOffsetSizeInBytes[i] = cumulativeColumnOffset;
                cumulativeColumnOffset += this._columnSizeInBytes[i] * this._numRows;
            }
        } else if (this._blockType == DataBlock.Type.ROW) {
            this._columnOffsets = new int[this._numColumns];
            this._rowSizeInBytes = DataBlockUtils.computeColumnOffsets((DataSchema)dataSchema, (int[])this._columnOffsets);
        }
    }

    public void setNullRowIds(@Nullable RoaringBitmap nullRowIds) throws IOException {
        this._fixedSizeDataOutputStream.writeInt(this._variableSizeDataByteArrayOutputStream.size());
        if (nullRowIds == null || nullRowIds.isEmpty()) {
            this._fixedSizeDataOutputStream.writeInt(0);
        } else {
            byte[] bitmapBytes = RoaringBitmapUtils.serialize((RoaringBitmap)nullRowIds);
            this._fixedSizeDataOutputStream.writeInt(bitmapBytes.length);
            this._variableSizeDataByteArrayOutputStream.write(bitmapBytes);
        }
    }

    public static RowDataBlock buildFromRows(List<Object[]> rows, DataSchema dataSchema) throws IOException {
        DataBlockBuilder rowBuilder = new DataBlockBuilder(dataSchema, DataBlock.Type.ROW);
        int numColumns = rowBuilder._numColumns;
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        Object[] nullPlaceholders = new Object[numColumns];
        for (int colId = 0; colId < numColumns; ++colId) {
            nullBitmaps[colId] = new RoaringBitmap();
            nullPlaceholders[colId] = columnDataTypes[colId].convert(storedColumnDataTypes[colId].getNullPlaceholder());
        }
        rowBuilder._numRows = rows.size();
        for (int rowId = 0; rowId < rows.size(); ++rowId) {
            Object[] row = rows.get(rowId);
            ByteBuffer byteBuffer = ByteBuffer.allocate(rowBuilder._rowSizeInBytes);
            block22: for (int colId = 0; colId < rowBuilder._numColumns; ++colId) {
                Object value = row[colId];
                if (value == null) {
                    nullBitmaps[colId].add(rowId);
                    value = nullPlaceholders[colId];
                }
                switch (rowBuilder._columnDataTypes[colId]) {
                    case INT: {
                        byteBuffer.putInt(((Number)value).intValue());
                        continue block22;
                    }
                    case LONG: {
                        byteBuffer.putLong(((Number)value).longValue());
                        continue block22;
                    }
                    case FLOAT: {
                        byteBuffer.putFloat(((Number)value).floatValue());
                        continue block22;
                    }
                    case DOUBLE: {
                        byteBuffer.putDouble(((Number)value).doubleValue());
                        continue block22;
                    }
                    case BIG_DECIMAL: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (BigDecimal)value);
                        continue block22;
                    }
                    case BOOLEAN: {
                        byteBuffer.putInt((Boolean)value != false ? 1 : 0);
                        continue block22;
                    }
                    case TIMESTAMP: {
                        byteBuffer.putLong(((Timestamp)value).getTime());
                        continue block22;
                    }
                    case STRING: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (String)value);
                        continue block22;
                    }
                    case BYTES: {
                        if (value instanceof byte[]) {
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, new ByteArray((byte[])value));
                            continue block22;
                        }
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (ByteArray)value);
                        continue block22;
                    }
                    case OBJECT: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, value);
                        continue block22;
                    }
                    case INT_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (int[])value);
                        continue block22;
                    }
                    case LONG_ARRAY: {
                        int length;
                        int[] ints;
                        if (value instanceof int[]) {
                            ints = (int[])value;
                            length = ints.length;
                            long[] longs = new long[length];
                            ArrayCopyUtils.copy((int[])ints, (long[])longs, (int)length);
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, longs);
                            continue block22;
                        }
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (long[])value);
                        continue block22;
                    }
                    case FLOAT_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (float[])value);
                        continue block22;
                    }
                    case DOUBLE_ARRAY: {
                        double[] doubles;
                        int length;
                        int[] ints;
                        if (value instanceof int[]) {
                            ints = (int[])value;
                            length = ints.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((int[])ints, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, doubles);
                            continue block22;
                        }
                        if (value instanceof long[]) {
                            long[] longs = (long[])value;
                            length = longs.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((long[])longs, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, doubles);
                            continue block22;
                        }
                        if (value instanceof float[]) {
                            float[] floats = (float[])value;
                            length = floats.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((float[])floats, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, doubles);
                            continue block22;
                        }
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (double[])value);
                        continue block22;
                    }
                    case BYTES_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (byte[][])value);
                        continue block22;
                    }
                    case STRING_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (String[])value);
                        continue block22;
                    }
                    case BOOLEAN_ARRAY: {
                        boolean[] booleans = (boolean[])value;
                        int length = booleans.length;
                        int[] ints = new int[length];
                        ArrayCopyUtils.copy((boolean[])booleans, (int[])ints, (int)length);
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, ints);
                        continue block22;
                    }
                    case TIMESTAMP_ARRAY: {
                        Timestamp[] timestamps = (Timestamp[])value;
                        int length = timestamps.length;
                        long[] longs = new long[length];
                        ArrayCopyUtils.copy((Timestamp[])timestamps, (long[])longs, (int)length);
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, longs);
                        continue block22;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type: %s for column: %s", rowBuilder._columnDataTypes[colId], rowBuilder._dataSchema.getColumnName(colId)));
                    }
                }
            }
            rowBuilder._fixedSizeDataByteArrayOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        }
        for (RoaringBitmap nullBitmap : nullBitmaps) {
            rowBuilder.setNullRowIds(nullBitmap);
        }
        return DataBlockBuilder.buildRowBlock(rowBuilder);
    }

    public static ColumnarDataBlock buildFromColumns(List<Object[]> columns, DataSchema dataSchema) throws IOException {
        int colId;
        DataBlockBuilder columnarBuilder = new DataBlockBuilder(dataSchema, DataBlock.Type.COLUMNAR);
        int numColumns = columnarBuilder._numColumns;
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        Object[] nullPlaceholders = new Object[numColumns];
        for (colId = 0; colId < numColumns; ++colId) {
            nullBitmaps[colId] = new RoaringBitmap();
            nullPlaceholders[colId] = columnDataTypes[colId].convert(storedColumnDataTypes[colId].getNullPlaceholder());
        }
        for (colId = 0; colId < columns.size(); ++colId) {
            Object[] column = columns.get(colId);
            columnarBuilder._numRows = column.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(columnarBuilder._numRows * columnarBuilder._columnSizeInBytes[colId]);
            switch (columnarBuilder._columnDataTypes[colId]) {
                case INT: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putInt(((Number)value).intValue());
                    }
                    break;
                }
                case LONG: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putLong(((Number)value).longValue());
                    }
                    break;
                }
                case FLOAT: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putFloat(((Number)value).floatValue());
                    }
                    break;
                }
                case DOUBLE: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putDouble(((Number)value).doubleValue());
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (BigDecimal)value);
                    }
                    break;
                }
                case BOOLEAN: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putInt((Boolean)value != false ? 1 : 0);
                    }
                    break;
                }
                case TIMESTAMP: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        byteBuffer.putLong(((Timestamp)value).getTime());
                    }
                    break;
                }
                case STRING: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (String)value);
                    }
                    break;
                }
                case BYTES: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (ByteArray)value);
                    }
                    break;
                }
                case OBJECT: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, value);
                    }
                    break;
                }
                case INT_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (int[])value);
                    }
                    break;
                }
                case LONG_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        if (value instanceof int[]) {
                            int[] ints = (int[])value;
                            int length = ints.length;
                            long[] longs = new long[length];
                            ArrayCopyUtils.copy((int[])ints, (long[])longs, (int)length);
                            DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, longs);
                            continue;
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (long[])value);
                    }
                    break;
                }
                case FLOAT_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (float[])value);
                    }
                    break;
                }
                case DOUBLE_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        double[] doubles;
                        int length;
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        if (value instanceof int[]) {
                            int[] ints = (int[])value;
                            length = ints.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((int[])ints, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, doubles);
                            continue;
                        }
                        if (value instanceof long[]) {
                            long[] longs = (long[])value;
                            length = longs.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((long[])longs, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, doubles);
                            continue;
                        }
                        if (value instanceof float[]) {
                            float[] floats = (float[])value;
                            length = floats.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((float[])floats, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, doubles);
                            continue;
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (double[])value);
                    }
                    break;
                }
                case BOOLEAN_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        int length = ((boolean[])value).length;
                        int[] ints = new int[length];
                        ArrayCopyUtils.copy((boolean[])((boolean[])value), (int[])ints, (int)length);
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, ints);
                    }
                    break;
                }
                case TIMESTAMP_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        int length = ((Timestamp[])value).length;
                        long[] longs = new long[length];
                        ArrayCopyUtils.copy((Timestamp[])((Timestamp[])value), (long[])longs, (int)length);
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, longs);
                    }
                    break;
                }
                case BYTES_ARRAY: 
                case STRING_ARRAY: {
                    Object value;
                    int rowId;
                    for (rowId = 0; rowId < columnarBuilder._numRows; ++rowId) {
                        value = column[rowId];
                        if (value == null) {
                            nullBitmaps[colId].add(rowId);
                            value = nullPlaceholders[colId];
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (String[])value);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported data type: %s for column: %s", columnarBuilder._columnDataTypes[colId], columnarBuilder._dataSchema.getColumnName(colId)));
                }
            }
            columnarBuilder._fixedSizeDataByteArrayOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        }
        for (RoaringBitmap nullBitmap : nullBitmaps) {
            columnarBuilder.setNullRowIds(nullBitmap);
        }
        return DataBlockBuilder.buildColumnarBlock(columnarBuilder);
    }

    private static RowDataBlock buildRowBlock(DataBlockBuilder builder) {
        return new RowDataBlock(builder._numRows, builder._dataSchema, DataBlockBuilder.getReverseDictionary(builder._dictionary), builder._fixedSizeDataByteArrayOutputStream.toByteArray(), builder._variableSizeDataByteArrayOutputStream.toByteArray());
    }

    private static ColumnarDataBlock buildColumnarBlock(DataBlockBuilder builder) {
        return new ColumnarDataBlock(builder._numRows, builder._dataSchema, DataBlockBuilder.getReverseDictionary(builder._dictionary), builder._fixedSizeDataByteArrayOutputStream.toByteArray(), builder._variableSizeDataByteArrayOutputStream.toByteArray());
    }

    private static String[] getReverseDictionary(Object2IntOpenHashMap<String> dictionary) {
        String[] reverseDictionary = new String[dictionary.size()];
        for (Object2IntMap.Entry entry : dictionary.object2IntEntrySet()) {
            reverseDictionary[entry.getIntValue()] = (String)entry.getKey();
        }
        return reverseDictionary;
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, BigDecimal value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byte[] bytes = BigDecimalUtils.serialize((BigDecimal)value);
        byteBuffer.putInt(bytes.length);
        builder._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, String value) {
        Object2IntOpenHashMap<String> dictionary = builder._dictionary;
        int dictId = dictionary.computeIntIfAbsent((Object)value, k -> dictionary.size());
        byteBuffer.putInt(dictId);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, ByteArray value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byte[] bytes = value.getBytes();
        byteBuffer.putInt(bytes.length);
        builder._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, @Nullable Object value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        if (value == null) {
            byteBuffer.putInt(0);
            builder._variableSizeDataOutputStream.writeInt(100);
        } else {
            int objectTypeValue = ObjectSerDeUtils.ObjectType.getObjectType(value).getValue();
            byte[] bytes = ObjectSerDeUtils.serialize(value, objectTypeValue);
            byteBuffer.putInt(bytes.length);
            builder._variableSizeDataOutputStream.writeInt(objectTypeValue);
            builder._variableSizeDataByteArrayOutputStream.write(bytes);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, int[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (int value : values) {
            builder._variableSizeDataOutputStream.writeInt(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, long[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (long value : values) {
            builder._variableSizeDataOutputStream.writeLong(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, float[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (float value : values) {
            builder._variableSizeDataOutputStream.writeFloat(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, double[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (double value : values) {
            builder._variableSizeDataOutputStream.writeDouble(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, String[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        Object2IntOpenHashMap<String> dictionary = builder._dictionary;
        for (String value : values) {
            int dictId = dictionary.computeIntIfAbsent((Object)value, k -> dictionary.size());
            builder._variableSizeDataOutputStream.writeInt(dictId);
        }
    }
}

