/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.accounting;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.accounting.CPUMemThreadLevelAccountingObjects;
import org.apache.pinot.core.accounting.utils.RunnerWorkerThreadOffsetProvider;
import org.apache.pinot.spi.accounting.ThreadAccountantFactory;
import org.apache.pinot.spi.accounting.ThreadExecutionContext;
import org.apache.pinot.spi.accounting.ThreadResourceUsageAccountant;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.CommonConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerQueryCPUMemAccountantFactory
implements ThreadAccountantFactory {
    public ThreadResourceUsageAccountant init(int numRunnerThreads, int numWorkerThreads, PinotConfiguration config) {
        return new PerQueryCPUMemResourceUsageAccountant(numRunnerThreads + numWorkerThreads, config);
    }

    public static class PerQueryCPUMemResourceUsageAccountant
    extends Tracing.DefaultThreadResourceUsageAccountant {
        static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
        private static final Logger LOGGER = LoggerFactory.getLogger(PerQueryCPUMemResourceUsageAccountant.class);
        private static final String ACCOUNTANT_TASK_NAME = "CPUMemThreadAccountant";
        private static final int ACCOUNTANT_PRIORITY = 4;
        private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(1, r -> {
            Thread thread = new Thread(r);
            thread.setPriority(4);
            thread.setDaemon(true);
            thread.setName(ACCOUNTANT_TASK_NAME);
            return thread;
        });
        private final int _numThreads;
        private final PinotConfiguration _config;
        private final RunnerWorkerThreadOffsetProvider _runnerWorkerThreadOffsetProvider;
        private final CPUMemThreadLevelAccountingObjects.TaskEntryHolder[] _taskStatus;
        private final ThreadLocal<ThreadResourceUsageProvider> _threadResourceUsageProvider;
        private final boolean _isThreadCPUSamplingEnabled;
        private final CPUMemThreadLevelAccountingObjects.StatsDigest _cpuTimeSamplesNS;
        private final boolean _isThreadMemorySamplingEnabled;
        private final CPUMemThreadLevelAccountingObjects.StatsDigest _memorySamplesBytes;
        private final CPUMemThreadLevelAccountingObjects.TaskEntry[] _lastQueryTask;
        private final Set<String> _inactiveQuery;
        private final List<AtomicReference<Exception>> _errorStatus;
        private final WatcherTask _watcherTask;

        public PerQueryCPUMemResourceUsageAccountant(int numThreads, PinotConfiguration config) {
            LOGGER.info("Initializing PerQueryCPUMemResourceUsageAccountant");
            this._numThreads = numThreads;
            this._config = config;
            this._runnerWorkerThreadOffsetProvider = new RunnerWorkerThreadOffsetProvider();
            boolean threadCpuTimeMeasurementEnabled = ThreadResourceUsageProvider.isThreadCpuTimeMeasurementEnabled();
            boolean threadMemoryMeasurementEnabled = ThreadResourceUsageProvider.isThreadMemoryMeasurementEnabled();
            LOGGER.info("threadCpuTimeMeasurementEnabled: {}, threadMemoryMeasurementEnabled: {}", (Object)threadCpuTimeMeasurementEnabled, (Object)threadMemoryMeasurementEnabled);
            boolean cpuSamplingConfig = config.getProperty("accounting.enable.thread.cpu.sampling", CommonConstants.Accounting.DEFAULT_ENABLE_THREAD_CPU_SAMPLING.booleanValue());
            boolean memorySamplingConfig = config.getProperty("accounting.enable.thread.memory.sampling", CommonConstants.Accounting.DEFAULT_ENABLE_THREAD_MEMORY_SAMPLING.booleanValue());
            LOGGER.info("cpuSamplingConfig: {}, memorySamplingConfig: {}", (Object)cpuSamplingConfig, (Object)memorySamplingConfig);
            this._isThreadCPUSamplingEnabled = cpuSamplingConfig && threadCpuTimeMeasurementEnabled;
            this._isThreadMemorySamplingEnabled = memorySamplingConfig && threadMemoryMeasurementEnabled;
            LOGGER.info("_isThreadCPUSamplingEnabled: {}, _isThreadMemorySamplingEnabled: {}", (Object)this._isThreadCPUSamplingEnabled, (Object)this._isThreadMemorySamplingEnabled);
            this._taskStatus = new CPUMemThreadLevelAccountingObjects.TaskEntryHolder[this._numThreads];
            this._errorStatus = new ArrayList<AtomicReference<Exception>>(this._numThreads);
            for (int i = 0; i < this._numThreads; ++i) {
                this._taskStatus[i] = new CPUMemThreadLevelAccountingObjects.TaskEntryHolder();
                this._errorStatus.add(new AtomicReference<Object>(null));
            }
            this._cpuTimeSamplesNS = this._isThreadCPUSamplingEnabled ? new CPUMemThreadLevelAccountingObjects.StatsDigest(this._numThreads) : null;
            this._memorySamplesBytes = this._isThreadMemorySamplingEnabled ? new CPUMemThreadLevelAccountingObjects.StatsDigest(this._numThreads) : null;
            this._threadResourceUsageProvider = new ThreadLocal();
            this._lastQueryTask = new CPUMemThreadLevelAccountingObjects.TaskEntry[this._numThreads];
            this._inactiveQuery = new HashSet<String>();
            this._watcherTask = new WatcherTask();
        }

        public void sampleUsage() {
            this.sampleThreadBytesAllocated();
            this.sampleThreadCPUTime();
        }

        public void sampleThreadCPUTime() {
            if (this._isThreadCPUSamplingEnabled) {
                int tid = this._runnerWorkerThreadOffsetProvider.get();
                this._cpuTimeSamplesNS._currentStatsSample[tid] = this.getThreadResourceUsageProvider().getThreadTimeNs();
            }
        }

        public void sampleThreadBytesAllocated() {
            if (this._isThreadMemorySamplingEnabled) {
                int tid = this._runnerWorkerThreadOffsetProvider.get();
                this._memorySamplesBytes._currentStatsSample[tid] = this.getThreadResourceUsageProvider().getThreadAllocatedBytes();
            }
        }

        private ThreadResourceUsageProvider getThreadResourceUsageProvider() {
            return this._threadResourceUsageProvider.get();
        }

        public void setThreadResourceUsageProvider(ThreadResourceUsageProvider threadResourceUsageProvider) {
            this._threadResourceUsageProvider.set(threadResourceUsageProvider);
        }

        public void createExecutionContextInner(@Nullable String queryId, int taskId, @Nullable ThreadExecutionContext parentContext) {
            int tid = this._runnerWorkerThreadOffsetProvider.get();
            if (parentContext == null) {
                assert (queryId != null);
                this._taskStatus[tid].setThreadTaskStatus(queryId, -1, Thread.currentThread());
            } else {
                this._taskStatus[tid].setThreadTaskStatus(parentContext.getQueryId(), taskId, parentContext.getAnchorThread());
            }
        }

        public ThreadExecutionContext getThreadExecutionContext() {
            int tid = this._runnerWorkerThreadOffsetProvider.get();
            return this._taskStatus[tid].getThreadTaskStatus();
        }

        public void clear() {
            int tid = this._runnerWorkerThreadOffsetProvider.get();
            this._taskStatus[tid].setToIdle();
            if (this._isThreadCPUSamplingEnabled) {
                this._cpuTimeSamplesNS._currentStatsSample[tid] = 0L;
            }
            if (this._isThreadMemorySamplingEnabled) {
                this._memorySamplesBytes._currentStatsSample[tid] = 0L;
            }
            this._threadResourceUsageProvider.set(null);
            super.clear();
        }

        public void startWatcherTask() {
            EXECUTOR_SERVICE.submit(this._watcherTask);
        }

        public void cleanInactive() {
            for (String inactiveQueryId : this._inactiveQuery) {
                if (this._isThreadCPUSamplingEnabled) {
                    this._cpuTimeSamplesNS._finishedTaskStatAggregator.remove(inactiveQueryId);
                }
                if (!this._isThreadMemorySamplingEnabled) continue;
                this._memorySamplesBytes._finishedTaskStatAggregator.remove(inactiveQueryId);
            }
            this._inactiveQuery.clear();
            if (this._isThreadCPUSamplingEnabled) {
                this._inactiveQuery.addAll(this._cpuTimeSamplesNS._finishedTaskStatAggregator.keySet());
            }
            if (this._isThreadMemorySamplingEnabled) {
                this._inactiveQuery.addAll(this._memorySamplesBytes._finishedTaskStatAggregator.keySet());
            }
        }

        public Map<String, AggregatedStats> aggregate(boolean isTriggered) {
            HashMap<String, AggregatedStats> ret = null;
            if (isTriggered) {
                ret = new HashMap<String, AggregatedStats>();
            }
            for (int threadId = 0; threadId < this._numThreads; ++threadId) {
                long currentCPUSample = this._isThreadCPUSamplingEnabled ? this._cpuTimeSamplesNS._currentStatsSample[threadId] : 0L;
                long currentMemSample = this._isThreadMemorySamplingEnabled ? this._memorySamplesBytes._currentStatsSample[threadId] : 0L;
                CPUMemThreadLevelAccountingObjects.TaskEntry currentTaskStatus = this._taskStatus[threadId].getThreadTaskStatus();
                LOGGER.trace("tid: {}, task: {}", (Object)threadId, (Object)currentTaskStatus);
                CPUMemThreadLevelAccountingObjects.TaskEntry lastQueryTask = this._lastQueryTask[threadId];
                if (!CPUMemThreadLevelAccountingObjects.TaskEntry.isSameTask(currentTaskStatus, lastQueryTask)) {
                    this._lastQueryTask[threadId] = currentTaskStatus;
                    if (lastQueryTask != null) {
                        long lastSample;
                        String lastQueryId = lastQueryTask.getQueryId();
                        if (this._isThreadCPUSamplingEnabled) {
                            lastSample = this._cpuTimeSamplesNS._lastStatSample[threadId];
                            this._cpuTimeSamplesNS._finishedTaskStatAggregator.merge(lastQueryId, lastSample, Long::sum);
                        }
                        if (this._isThreadMemorySamplingEnabled) {
                            lastSample = this._memorySamplesBytes._lastStatSample[threadId];
                            this._memorySamplesBytes._finishedTaskStatAggregator.merge(lastQueryId, lastSample, Long::sum);
                        }
                    }
                }
                if (this._isThreadCPUSamplingEnabled) {
                    this._cpuTimeSamplesNS._lastStatSample[threadId] = currentCPUSample;
                }
                if (this._isThreadMemorySamplingEnabled) {
                    this._memorySamplesBytes._lastStatSample[threadId] = currentMemSample;
                }
                if (currentTaskStatus == null) continue;
                String queryId = currentTaskStatus.getQueryId();
                this._inactiveQuery.remove(queryId);
                if (!isTriggered) continue;
                Thread thread = currentTaskStatus.getAnchorThread();
                int finalThreadId = threadId;
                boolean isAnchorThread = currentTaskStatus.isAnchorThread();
                ret.compute(queryId, (k, v) -> v == null ? new AggregatedStats(currentCPUSample, currentMemSample, thread, isAnchorThread, finalThreadId, queryId) : v.merge(currentCPUSample, currentMemSample, isAnchorThread, finalThreadId));
            }
            if (isTriggered) {
                for (Map.Entry queryIdResult : ret.entrySet()) {
                    String activeQueryId = (String)queryIdResult.getKey();
                    long accumulatedCPUValue = this._isThreadCPUSamplingEnabled ? this._cpuTimeSamplesNS._finishedTaskStatAggregator.getOrDefault(activeQueryId, 0L) : 0L;
                    long accumulatedMemValue = this._isThreadMemorySamplingEnabled ? this._memorySamplesBytes._finishedTaskStatAggregator.getOrDefault(activeQueryId, 0L) : 0L;
                    ((AggregatedStats)queryIdResult.getValue()).merge(accumulatedCPUValue, accumulatedMemValue, false, -2);
                }
            }
            return ret;
        }

        public Exception getErrorStatus() {
            return this._errorStatus.get(this._runnerWorkerThreadOffsetProvider.get()).getAndSet(null);
        }

        class WatcherTask
        implements Runnable {
            private final long _maxHeapSize = MEMORY_MX_BEAN.getHeapMemoryUsage().getMax();
            private final long _minMemoryFootprintForKill;
            private final long _panicLevel;
            private final long _criticalLevel;
            private final int _gcTriggerCount;
            private final long _alarmingLevel;
            private final int _normalSleepTime;
            private final int _alarmingSleepTimeDenominator;
            private final int _alarmingSleepTime;
            private final boolean _oomKillQueryEnabled;
            private final boolean _publishHeapUsageMetric;
            private long _usedBytes;
            private int _sleepTime;
            private int _numQueriesKilledConsecutively;
            private Map<String, AggregatedStats> _aggregatedUsagePerActiveQuery;
            private TriggeringLevel _triggeringLevel;

            WatcherTask() {
                this._minMemoryFootprintForKill = (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.min.memory.footprint.to.kill.ratio", 0.025));
                this._panicLevel = (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.panic.heap.usage.ratio", (double)0.99f));
                this._criticalLevel = (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.critical.heap.usage.ratio", (double)0.96f));
                this._gcTriggerCount = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.gc.backoff.count", 5);
                this._alarmingLevel = (long)((double)this._maxHeapSize * PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.alarming.usage.ratio", 0.75));
                this._normalSleepTime = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.sleep.ms", 30);
                this._alarmingSleepTimeDenominator = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.sleep.time.denominator", 3);
                this._alarmingSleepTime = this._normalSleepTime / this._alarmingSleepTimeDenominator;
                this._oomKillQueryEnabled = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.oom.enable.killing.query", false);
                this._publishHeapUsageMetric = PerQueryCPUMemResourceUsageAccountant.this._config.getProperty("accounting.publishing.jvm.heap.usage", false);
                this._numQueriesKilledConsecutively = 0;
            }

            @Override
            public void run() {
                LOGGER.info("Starting accountant task for PerQueryCPUMemAccountant.");
                LOGGER.info("Xmx is {}", (Object)this._maxHeapSize);
                LOGGER.info("_alarmingLevel of on heap memory is {}", (Object)this._alarmingLevel);
                LOGGER.info("_criticalLevel of on heap memory is {}", (Object)this._criticalLevel);
                while (true) {
                    LOGGER.debug("Running timed task for PerQueryCPUMemAccountant.");
                    this._triggeringLevel = TriggeringLevel.Normal;
                    this._sleepTime = this._normalSleepTime;
                    this._aggregatedUsagePerActiveQuery = null;
                    try {
                        this.collectTriggerMetrics();
                        if (this.outOfMemoryPanicTrigger()) continue;
                        this.evalTriggers();
                        this._aggregatedUsagePerActiveQuery = PerQueryCPUMemResourceUsageAccountant.this.aggregate(this._triggeringLevel.ordinal() > TriggeringLevel.Normal.ordinal());
                        this.triggeredActions();
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception while executing stats aggregation and query kill", (Throwable)e);
                        continue;
                    }
                    finally {
                        if (this._aggregatedUsagePerActiveQuery != null) {
                            LOGGER.debug(this._aggregatedUsagePerActiveQuery.toString());
                        }
                        if (this._publishHeapUsageMetric) {
                            ServerMetrics.get().setValueOfGlobalGauge((AbstractMetrics.Gauge)ServerGauge.JVM_HEAP_USED_BYTES, this._usedBytes);
                        }
                        PerQueryCPUMemResourceUsageAccountant.this.cleanInactive();
                        this.reschedule();
                        continue;
                    }
                    break;
                }
            }

            private void collectTriggerMetrics() {
                this._usedBytes = MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
                LOGGER.debug("Heap used bytes {}", (Object)this._usedBytes);
            }

            private boolean outOfMemoryPanicTrigger() {
                if (this._usedBytes >= this._panicLevel) {
                    this.killAllQueries();
                    this._triggeringLevel = TriggeringLevel.HeapMemoryPanic;
                    LOGGER.error("Heap used bytes {}, greater than _panicLevel {}, Killed all queries and triggered gc!", (Object)this._usedBytes, (Object)this._panicLevel);
                    PerQueryCPUMemResourceUsageAccountant.this.aggregate(false);
                    return true;
                }
                return false;
            }

            private void evalTriggers() {
                if (this._usedBytes > this._criticalLevel) {
                    this._triggeringLevel = TriggeringLevel.HeapMemoryCritical;
                } else if (this._usedBytes > this._alarmingLevel) {
                    this._triggeringLevel = LOGGER.isDebugEnabled() ? TriggeringLevel.HeapMemoryAlarmingVerbose : this._triggeringLevel;
                    this._sleepTime = this._alarmingSleepTime;
                }
            }

            private void triggeredActions() {
                switch (this._triggeringLevel) {
                    case HeapMemoryCritical: {
                        LOGGER.debug("Heap used bytes {} exceeds critical level", (Object)this._usedBytes);
                        this.killMostExpensiveQuery();
                        break;
                    }
                    case HeapMemoryAlarmingVerbose: {
                        LOGGER.warn("Heap used bytes {} exceeds alarming level", (Object)this._usedBytes);
                        LOGGER.warn("Query usage aggregation results {}", (Object)this._aggregatedUsagePerActiveQuery.toString());
                        this._numQueriesKilledConsecutively = 0;
                        break;
                    }
                    default: {
                        this._numQueriesKilledConsecutively = 0;
                    }
                }
            }

            void reschedule() {
                try {
                    Thread.sleep(this._sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            void killAllQueries() {
                if (this._oomKillQueryEnabled) {
                    int killedCount = 0;
                    for (int i = 0; i < PerQueryCPUMemResourceUsageAccountant.this._numThreads; ++i) {
                        CPUMemThreadLevelAccountingObjects.TaskEntry taskEntry = PerQueryCPUMemResourceUsageAccountant.this._taskStatus[i].getThreadTaskStatus();
                        if (taskEntry == null || !taskEntry.isAnchorThread()) continue;
                        PerQueryCPUMemResourceUsageAccountant.this._errorStatus.get(i).set(new RuntimeException("Query killed due to server out of memory!"));
                        taskEntry.getAnchorThread().interrupt();
                        ++killedCount;
                    }
                    ServerMetrics.get().addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.QUERIES_PREEMPTED, (long)killedCount);
                    try {
                        Thread.sleep(this._normalSleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.gc();
                    this._numQueriesKilledConsecutively = 0;
                }
            }

            private void killMostExpensiveQuery() {
                if (!this._aggregatedUsagePerActiveQuery.isEmpty() && this._numQueriesKilledConsecutively >= this._gcTriggerCount) {
                    System.gc();
                    this._numQueriesKilledConsecutively = 0;
                    try {
                        Thread.sleep(this._normalSleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this._usedBytes = MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
                    if (this._usedBytes < this._criticalLevel) {
                        return;
                    }
                }
                if (!PerQueryCPUMemResourceUsageAccountant.this._isThreadMemorySamplingEnabled && !PerQueryCPUMemResourceUsageAccountant.this._isThreadCPUSamplingEnabled) {
                    LOGGER.warn("Heap used bytes {} exceeds critical level", (Object)this._usedBytes);
                    LOGGER.warn("But unable to kill query because neither memory nor cpu tracking is enabled");
                    return;
                }
                if (this._aggregatedUsagePerActiveQuery.isEmpty()) {
                    LOGGER.debug("Heap used bytes {} exceeds critical level, but no active queries", (Object)this._usedBytes);
                    return;
                }
                if (PerQueryCPUMemResourceUsageAccountant.this._isThreadMemorySamplingEnabled) {
                    boolean shouldKill;
                    AggregatedStats maxUsageTuple = Collections.max(this._aggregatedUsagePerActiveQuery.values(), Comparator.comparing(AggregatedStats::getAllocatedBytes));
                    boolean bl = shouldKill = this._oomKillQueryEnabled && maxUsageTuple._allocatedBytes > this._minMemoryFootprintForKill;
                    if (shouldKill) {
                        PerQueryCPUMemResourceUsageAccountant.this._errorStatus.get(maxUsageTuple._threadId).set(new RuntimeException(String.format(" Query %s got killed because using %d bytes of memory, exceeding the quota", maxUsageTuple._queryId, maxUsageTuple.getAllocatedBytes())));
                        this.interruptRunnerThread(maxUsageTuple.getThread());
                    }
                    LOGGER.error("Heap used bytes {} exceeds critical level {}", (Object)this._usedBytes, (Object)this._criticalLevel);
                    LOGGER.error("Query {} got picked because using {} bytes of memory, actual kill committed {}", new Object[]{maxUsageTuple._queryId, maxUsageTuple._allocatedBytes, shouldKill});
                } else {
                    AggregatedStats maxUsageTuple = Collections.max(this._aggregatedUsagePerActiveQuery.values(), Comparator.comparing(AggregatedStats::getCpuNS));
                    if (this._oomKillQueryEnabled) {
                        PerQueryCPUMemResourceUsageAccountant.this._errorStatus.get(maxUsageTuple._threadId).set(new RuntimeException(String.format(" Query %s got killed because server memory pressure, using %d ns of CPU time", maxUsageTuple._queryId, maxUsageTuple.getAllocatedBytes())));
                        this.interruptRunnerThread(maxUsageTuple.getThread());
                    }
                    LOGGER.error("Heap used bytes {} exceeds critical level {}", (Object)this._usedBytes, (Object)this._criticalLevel);
                    LOGGER.error("Query {} got picked because using {} ns of cpu time, actual kill committed {}", new Object[]{maxUsageTuple._allocatedBytes, maxUsageTuple._queryId, this._oomKillQueryEnabled});
                }
                LOGGER.error("Query aggregation results {} for the previous kill.", (Object)this._aggregatedUsagePerActiveQuery.toString());
            }

            private void interruptRunnerThread(Thread thread) {
                thread.interrupt();
                ServerMetrics.get().addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.QUERIES_PREEMPTED, 1L);
                ++this._numQueriesKilledConsecutively;
            }
        }

        static class AggregatedStats {
            final String _queryId;
            final Thread _thread;
            int _threadId;
            boolean _isAnchorThread;
            long _allocatedBytes;
            long _cpuNS;

            public AggregatedStats(long cpuNS, long allocatedBytes, Thread thread, Boolean isAnchorThread, int threadId, String queryId) {
                this._cpuNS = cpuNS;
                this._allocatedBytes = allocatedBytes;
                this._thread = thread;
                this._threadId = threadId;
                this._queryId = queryId;
                this._isAnchorThread = isAnchorThread;
            }

            public String toString() {
                return "AggregatedStats{_queryId='" + this._queryId + "', _allocatedBytes=" + this._allocatedBytes + ", _cpuNS=" + this._cpuNS + ", _thread=" + this._thread + ", _threadId=" + this._threadId + "}";
            }

            public long getCpuNS() {
                return this._cpuNS;
            }

            public long getAllocatedBytes() {
                return this._allocatedBytes;
            }

            public Thread getThread() {
                return this._thread;
            }

            public AggregatedStats merge(long cpuNS, long memoryBytes, boolean isAnchorThread, int threadId) {
                this._cpuNS += cpuNS;
                this._allocatedBytes += memoryBytes;
                if (isAnchorThread) {
                    this._isAnchorThread = true;
                    this._threadId = threadId;
                }
                return this;
            }
        }

        static enum TriggeringLevel {
            Normal,
            HeapMemoryAlarmingVerbose,
            HeapMemoryCritical,
            HeapMemoryPanic;

        }
    }
}

