/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.accounting;

import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.spi.accounting.ThreadExecutionContext;

public class CPUMemThreadLevelAccountingObjects {

    public static class TaskEntry
    implements ThreadExecutionContext {
        private final String _queryId;
        private final int _taskId;
        private final Thread _anchorThread;

        public boolean isAnchorThread() {
            return this._taskId == -1;
        }

        public TaskEntry(String queryId, int taskId, Thread anchorThread) {
            this._queryId = queryId;
            this._taskId = taskId;
            this._anchorThread = anchorThread;
        }

        public static boolean isSameTask(TaskEntry currentTaskStatus, TaskEntry lastQueryTask) {
            if (currentTaskStatus == null) {
                return lastQueryTask == null;
            }
            if (lastQueryTask == null) {
                return false;
            }
            return Objects.equals(currentTaskStatus.getQueryId(), lastQueryTask.getQueryId()) || currentTaskStatus.getTaskId() == lastQueryTask.getTaskId();
        }

        public String getQueryId() {
            return this._queryId;
        }

        public int getTaskId() {
            return this._taskId;
        }

        public Thread getAnchorThread() {
            return this._anchorThread;
        }

        public String toString() {
            return "TaskEntry{_queryId='" + this._queryId + "', _taskId=" + this._taskId + ", _rootThread=" + this._anchorThread + "}";
        }
    }

    public static class TaskEntryHolder {
        AtomicReference<TaskEntry> _threadTaskStatus = new AtomicReference<Object>(null);

        public void setToIdle() {
            this._threadTaskStatus.set(null);
        }

        @Nullable
        public TaskEntry getThreadTaskStatus() {
            return this._threadTaskStatus.get();
        }

        public TaskEntryHolder setThreadTaskStatus(@Nonnull String queryId, int taskId, @Nonnull Thread thread) {
            this._threadTaskStatus.set(new TaskEntry(queryId, taskId, thread));
            return this;
        }
    }

    public static class StatsDigest {
        final long[] _currentStatsSample;
        final long[] _lastStatSample;
        final HashMap<String, Long> _finishedTaskStatAggregator;

        StatsDigest(int numThreads) {
            this._currentStatsSample = new long[numThreads];
            this._lastStatSample = new long[numThreads];
            this._finishedTaskStatAggregator = new HashMap();
        }
    }
}

