/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class CheckpointConf {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointConf.class);
    private final long checkpointPeriod;
    private final long checkpointCheckPeriod;
    private final long checkpointTxnCount;
    private final int maxRetriesOnMergeError;
    private final String legacyOivImageDir;
    private double quietMultiplier;

    public CheckpointConf(Configuration conf) {
        this.checkpointCheckPeriod = conf.getTimeDuration("dfs.namenode.checkpoint.check.period", 60L, TimeUnit.SECONDS);
        this.checkpointPeriod = conf.getTimeDuration("dfs.namenode.checkpoint.period", 3600L, TimeUnit.SECONDS);
        this.checkpointTxnCount = conf.getLong("dfs.namenode.checkpoint.txns", 1000000L);
        this.maxRetriesOnMergeError = conf.getInt("dfs.namenode.checkpoint.max-retries", 3);
        this.legacyOivImageDir = conf.get("dfs.namenode.legacy-oiv-image.dir");
        this.quietMultiplier = conf.getDouble("dfs.namenode.checkpoint.check.quiet-multiplier", 1.5);
        CheckpointConf.warnForDeprecatedConfigs(conf);
    }

    private static void warnForDeprecatedConfigs(Configuration conf) {
        for (String key : ImmutableList.of("fs.checkpoint.size", "dfs.namenode.checkpoint.size")) {
            if (conf.get(key) == null) continue;
            LOG.warn("Configuration key " + key + " is deprecated! Ignoring... Instead please specify a value for " + "dfs.namenode.checkpoint.txns");
        }
    }

    public long getPeriod() {
        return this.checkpointPeriod;
    }

    public long getCheckPeriod() {
        return Math.min(this.checkpointCheckPeriod, this.checkpointPeriod);
    }

    public long getTxnCount() {
        return this.checkpointTxnCount;
    }

    public int getMaxRetriesOnMergeError() {
        return this.maxRetriesOnMergeError;
    }

    public String getLegacyOivImageDir() {
        return this.legacyOivImageDir;
    }

    public double getQuietPeriod() {
        return (double)this.checkpointPeriod * this.quietMultiplier;
    }
}

