/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectReader;
import io.trino.hadoop.$internal.org.apache.commons.cli.CommandLine;
import io.trino.hadoop.$internal.org.apache.commons.cli.Option;
import io.trino.hadoop.$internal.org.apache.commons.lang3.StringUtils;
import io.trino.hadoop.$internal.org.apache.commons.text.TextStringBuilder;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.HostsFileReader;

public abstract class Command
extends Configured
implements Closeable {
    private static final ObjectReader READER = new ObjectMapper().readerFor(HashMap.class);
    static final Logger LOG = LoggerFactory.getLogger(Command.class);
    private Map<String, String> validArgs = new HashMap<String, String>();
    private URI clusterURI;
    private FileSystem fs = null;
    private DiskBalancerCluster cluster = null;
    private int topNodes = 0;
    private PrintStream ps;
    private static final Path DEFAULT_LOG_DIR = new Path("/system/diskbalancer");
    private Path diskBalancerLogs;

    public Command(Configuration conf) {
        this(conf, System.out);
    }

    public Command(Configuration conf, PrintStream ps) {
        super(conf);
        this.ps = ps;
    }

    @Override
    public void close() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    PrintStream getPrintStream() {
        return this.ps;
    }

    public abstract void execute(CommandLine var1) throws Exception;

    public abstract void printHelp();

    protected DiskBalancerCluster readClusterInfo(CommandLine cmd) throws Exception {
        Preconditions.checkNotNull(cmd);
        this.setClusterURI(FileSystem.getDefaultUri(this.getConf()));
        LOG.debug("using name node URI : {}", (Object)this.getClusterURI());
        ClusterConnector connector = ConnectorFactory.getCluster(this.clusterURI, this.getConf());
        this.cluster = new DiskBalancerCluster(connector);
        LOG.debug("Reading cluster info");
        this.cluster.readClusterInfo();
        return this.cluster;
    }

    protected void setOutputPath(String path) throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MMM-dd-HH-mm-ss");
        Date now = new Date();
        this.fs = FileSystem.get(this.getClusterURI(), this.getConf());
        this.diskBalancerLogs = path == null || path.isEmpty() ? (this.getClusterURI().getScheme().startsWith("file") ? new Path(System.getProperty("user.dir") + DEFAULT_LOG_DIR.toString() + "/" + format.format(now)) : new Path(DEFAULT_LOG_DIR.toString() + "/" + format.format(now))) : new Path(path);
        if (this.fs.exists(this.diskBalancerLogs)) {
            LOG.debug("Another Diskbalancer instance is running ? - Target Directory already exists. {}", (Object)this.diskBalancerLogs);
            throw new IOException("Another DiskBalancer files already exist at the target location. " + this.diskBalancerLogs.toString());
        }
        this.fs.mkdirs(this.diskBalancerLogs);
    }

    protected void setNodesToProcess(DiskBalancerDataNode node) {
        LinkedList<DiskBalancerDataNode> nodelist = new LinkedList<DiskBalancerDataNode>();
        nodelist.add(node);
        this.setNodesToProcess(nodelist);
    }

    protected void setNodesToProcess(List<DiskBalancerDataNode> nodes) {
        if (this.cluster == null) {
            throw new IllegalStateException("Set nodes to process invoked before initializing cluster. Illegal usage.");
        }
        this.cluster.setNodesToProcess(nodes);
    }

    DiskBalancerDataNode getNode(String nodeName) {
        DiskBalancerDataNode node = null;
        if (nodeName == null || nodeName.isEmpty()) {
            return node;
        }
        if (this.cluster.getNodes().size() == 0) {
            return node;
        }
        node = this.cluster.getNodeByName(nodeName);
        if (node != null) {
            return node;
        }
        node = this.cluster.getNodeByIPAddress(nodeName);
        if (node != null) {
            return node;
        }
        node = this.cluster.getNodeByUUID(nodeName);
        return node;
    }

    protected Set<String> getNodeList(String listArg) throws IOException {
        TreeSet<String> resultSet = new TreeSet<String>();
        if (listArg == null || listArg.isEmpty()) {
            return resultSet;
        }
        if (listArg.startsWith("file://")) {
            URL listURL = new URL(listArg);
            try {
                HostsFileReader.readFileToSet("include", Paths.get(listURL.getPath(), new String[0]).toString(), resultSet);
            }
            catch (NoSuchFileException e) {
                String warnMsg = String.format("The input host file path '%s' is not a valid path. Please make sure the host file exists.", listArg);
                throw new DiskBalancerException(warnMsg, DiskBalancerException.Result.INVALID_HOST_FILE_PATH);
            }
        } else {
            String nodeData = listArg;
            String[] nodes = nodeData.split(",");
            if (nodes.length == 0) {
                String warnMsg = "The number of input nodes is 0. Please input the valid nodes.";
                throw new DiskBalancerException(warnMsg, DiskBalancerException.Result.INVALID_NODE);
            }
            Collections.addAll(resultSet, nodes);
        }
        return resultSet;
    }

    protected List<DiskBalancerDataNode> getNodes(String listArg) throws IOException {
        Set<String> nodeNames = null;
        ArrayList<DiskBalancerDataNode> nodeList = Lists.newArrayList();
        ArrayList<String> invalidNodeList = Lists.newArrayList();
        if (listArg == null || listArg.isEmpty()) {
            return nodeList;
        }
        nodeNames = this.getNodeList(listArg);
        DiskBalancerDataNode node = null;
        if (!nodeNames.isEmpty()) {
            for (String name : nodeNames) {
                node = this.getNode(name);
                if (node != null) {
                    nodeList.add(node);
                    continue;
                }
                invalidNodeList.add(name);
            }
        }
        if (!invalidNodeList.isEmpty()) {
            String invalidNodes = StringUtils.join(invalidNodeList.toArray(), ",");
            String warnMsg = String.format("The node(s) '%s' not found. Please make sure that '%s' exists in the cluster.", invalidNodes, invalidNodes);
            throw new DiskBalancerException(warnMsg, DiskBalancerException.Result.INVALID_NODE);
        }
        return nodeList;
    }

    protected void verifyCommandOptions(String commandName, CommandLine cmd) {
        Iterator iter = cmd.iterator();
        while (iter.hasNext()) {
            Option opt = (Option)iter.next();
            if (this.validArgs.containsKey(opt.getLongOpt())) continue;
            String errMessage = String.format("%nInvalid argument found for command %s : %s%n", commandName, opt.getLongOpt());
            StringBuilder validArguments = new StringBuilder();
            validArguments.append(String.format("Valid arguments are : %n", new Object[0]));
            for (Map.Entry<String, String> args : this.validArgs.entrySet()) {
                String key = args.getKey();
                String desc = args.getValue();
                String s2 = String.format("\t %s : %s %n", key, desc);
                validArguments.append(s2);
            }
            LOG.error(errMessage + validArguments.toString());
            throw new IllegalArgumentException("Invalid Arguments found.");
        }
    }

    public URI getClusterURI() {
        return this.clusterURI;
    }

    public void setClusterURI(URI clusterURI) {
        this.clusterURI = clusterURI;
    }

    public ClientDatanodeProtocol getDataNodeProxy(String datanode) throws IOException {
        InetSocketAddress datanodeAddr = NetUtils.createSocketAddr(datanode);
        this.getConf().set("hadoop.security.service.user.name.key", this.getConf().get("dfs.datanode.kerberos.principal", ""));
        ClientDatanodeProtocol dnProtocol = DFSUtilClient.createClientDatanodeProtocolProxy(datanodeAddr, Command.getUGI(), this.getConf(), NetUtils.getSocketFactory(this.getConf(), ClientDatanodeProtocol.class));
        return dnProtocol;
    }

    private static UserGroupInformation getUGI() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    protected FSDataOutputStream create(String fileName) throws IOException {
        Preconditions.checkNotNull(fileName);
        if (this.fs == null) {
            this.fs = FileSystem.get(this.getConf());
        }
        return this.fs.create(new Path(this.diskBalancerLogs, fileName));
    }

    protected FSDataInputStream open(String fileName) throws IOException {
        Preconditions.checkNotNull(fileName);
        if (this.fs == null) {
            this.fs = FileSystem.get(this.getConf());
        }
        return this.fs.open(new Path(fileName));
    }

    protected Path getOutputPath() {
        return this.diskBalancerLogs;
    }

    protected void addValidCommandParameters(String key, String desc) {
        this.validArgs.put(key, desc);
    }

    @VisibleForTesting
    DiskBalancerCluster getCluster() {
        return this.cluster;
    }

    protected int getDefaultTop() {
        return 100;
    }

    protected void recordOutput(TextStringBuilder result, String outputLine) {
        LOG.info(outputLine);
        result.appendln(outputLine);
    }

    protected int parseTopNodes(CommandLine cmd, TextStringBuilder result) throws IllegalArgumentException {
        String outputLine = "";
        int nodes = 0;
        String topVal = cmd.getOptionValue("top");
        if (StringUtils.isBlank(topVal)) {
            outputLine = String.format("No top limit specified, using default top value %d.", this.getDefaultTop());
            LOG.info(outputLine);
            result.appendln(outputLine);
            nodes = this.getDefaultTop();
        } else {
            try {
                nodes = Integer.parseInt(topVal);
            }
            catch (NumberFormatException nfe) {
                outputLine = String.format("Top limit input is not numeric, using default top value %d.", this.getDefaultTop());
                LOG.info(outputLine);
                result.appendln(outputLine);
                nodes = this.getDefaultTop();
            }
            if (nodes <= 0) {
                throw new IllegalArgumentException("Top limit input should be a positive numeric value");
            }
        }
        return Math.min(nodes, this.cluster.getNodes().size());
    }

    protected void populatePathNames(DiskBalancerDataNode node) throws IOException {
        if (this.getClusterURI().getScheme().startsWith("file")) {
            return;
        }
        String dnAddress = node.getDataNodeIP() + ":" + node.getDataNodePort();
        ClientDatanodeProtocol dnClient = this.getDataNodeProxy(dnAddress);
        String volumeNameJson = dnClient.getDiskBalancerSetting("DiskBalancerVolumeName");
        Map volumeMap = (Map)READER.readValue(volumeNameJson);
        for (DiskBalancerVolumeSet set : node.getVolumeSets().values()) {
            for (DiskBalancerVolume vol : set.getVolumes()) {
                if (!volumeMap.containsKey(vol.getUuid())) continue;
                vol.setPath((String)volumeMap.get(vol.getUuid()));
            }
        }
    }

    public void setTopNodes(int topNodes) {
        this.topNodes = topNodes;
    }

    public int getTopNodes() {
        return this.topNodes;
    }

    @VisibleForTesting
    public void setCluster(DiskBalancerCluster newCluster) {
        this.cluster = newCluster;
    }
}

