/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.util.SequentialNumber;

@InterfaceAudience.Private
public class SequentialBlockIdGenerator
extends SequentialNumber {
    public static final long LAST_RESERVED_BLOCK_ID = 0x40000000L;
    private final BlockManager blockManager;

    SequentialBlockIdGenerator(BlockManager blockManagerRef) {
        super(0x40000000L);
        this.blockManager = blockManagerRef;
    }

    @Override
    public long nextValue() {
        Block b = new Block(super.nextValue());
        while (this.isValidBlock(b)) {
            b.setBlockId(super.nextValue());
        }
        if (b.getBlockId() < 0L) {
            throw new IllegalStateException("All positive block IDs are used, wrapping to negative IDs, which might conflict with erasure coded block groups.");
        }
        return b.getBlockId();
    }

    private boolean isValidBlock(Block b) {
        BlockInfo bi = this.blockManager.getStoredBlock(b);
        return bi != null && bi.getBlockCollectionId() != -1L;
    }
}

