/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.protobuf.RpcController;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.proto.InterDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;

@InterfaceAudience.Private
public class InterDatanodeProtocolServerSideTranslatorPB
implements InterDatanodeProtocolPB {
    private final InterDatanodeProtocol impl;

    public InterDatanodeProtocolServerSideTranslatorPB(InterDatanodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public InterDatanodeProtocolProtos.InitReplicaRecoveryResponseProto initReplicaRecovery(RpcController unused, InterDatanodeProtocolProtos.InitReplicaRecoveryRequestProto request) throws ServiceException {
        ReplicaRecoveryInfo r;
        BlockRecoveryCommand.RecoveringBlock b = PBHelper.convert(request.getBlock());
        try {
            r = this.impl.initReplicaRecovery(b);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        if (r == null) {
            return InterDatanodeProtocolProtos.InitReplicaRecoveryResponseProto.newBuilder().setReplicaFound(false).build();
        }
        return InterDatanodeProtocolProtos.InitReplicaRecoveryResponseProto.newBuilder().setReplicaFound(true).setBlock(PBHelperClient.convert(r)).setState(PBHelper.convert(r.getOriginalReplicaState())).build();
    }

    @Override
    public InterDatanodeProtocolProtos.UpdateReplicaUnderRecoveryResponseProto updateReplicaUnderRecovery(RpcController unused, InterDatanodeProtocolProtos.UpdateReplicaUnderRecoveryRequestProto request) throws ServiceException {
        String storageID;
        try {
            storageID = this.impl.updateReplicaUnderRecovery(PBHelperClient.convert(request.getBlock()), request.getRecoveryId(), request.getNewBlockId(), request.getNewLength());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return InterDatanodeProtocolProtos.UpdateReplicaUnderRecoveryResponseProto.newBuilder().setStorageUuid(storageID).build();
    }
}

