/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Preconditions;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduClientWrapper;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.RowError;
import org.apache.kudu.client.SessionConfiguration;

public final class KuduOperationApplier
implements AutoCloseable {
    private static final int bufferMaxOperations = 1000;
    private int currentOperationsInBuffer;
    private final KuduSession kuduSession;

    private KuduOperationApplier(KuduSession kuduSession) {
        kuduSession.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        kuduSession.setMutationBufferSpace(1000);
        this.kuduSession = kuduSession;
        this.currentOperationsInBuffer = 0;
    }

    public static KuduOperationApplier fromKuduClientWrapper(KuduClientWrapper kuduClientWrapper) {
        KuduSession session = kuduClientWrapper.newSession();
        return new KuduOperationApplier(session);
    }

    public static KuduOperationApplier fromKuduClientSession(KuduClientSession kuduClientSession) {
        KuduSession session = kuduClientSession.newSession();
        return new KuduOperationApplier(session);
    }

    public void applyOperationAsync(Operation operation) throws KuduException {
        OperationResponse operationResponse;
        if (this.currentOperationsInBuffer >= 1000) {
            List operationResponses = this.kuduSession.flush();
            this.verifyNoErrors(operationResponses);
        }
        Preconditions.checkState(((operationResponse = this.kuduSession.apply(operation)) == null ? 1 : 0) != 0, (Object)"KuduSession must be configured with MANUAL_FLUSH mode");
        ++this.currentOperationsInBuffer;
    }

    private void verifyNoErrors(List<OperationResponse> operationResponses) {
        List failedOperations = operationResponses.stream().map(FailedOperation::fromOperationResponse).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!failedOperations.isEmpty()) {
            FailedOperation firstError = (FailedOperation)failedOperations.get(0);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error while applying %s kudu operation(s); First error: %s: %s", failedOperations.size(), firstError.operationResponse.getOperation().getChangeType().toString(), firstError.rowError));
        }
        this.currentOperationsInBuffer = 0;
    }

    @Override
    public void close() throws KuduException {
        List operationResponses = this.kuduSession.close();
        this.verifyNoErrors(operationResponses);
    }

    private static class FailedOperation {
        public RowError rowError;
        public OperationResponse operationResponse;

        public static Optional<FailedOperation> fromOperationResponse(OperationResponse operationResponse) {
            return Optional.ofNullable(operationResponse).flatMap(response -> Optional.ofNullable(response.getRowError())).map(rowError -> new FailedOperation(operationResponse, (RowError)rowError));
        }

        private FailedOperation(OperationResponse operationResponse, RowError rowError) {
            this.operationResponse = operationResponse;
            this.rowError = rowError;
        }
    }
}

