/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.kudu.KuduClientConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public final class KuduSessionProperties {
    private static final String DYNAMIC_FILTERING_WAIT_TIMEOUT = "dynamic_filtering_wait_timeout";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public KuduSessionProperties(KuduClientConfig kuduConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadataUtil.durationProperty((String)DYNAMIC_FILTERING_WAIT_TIMEOUT, (String)"Duration to wait for completion of dynamic filters", (Duration)kuduConfig.getDynamicFilteringWaitTimeout(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static Duration getDynamicFilteringWaitTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(DYNAMIC_FILTERING_WAIT_TIMEOUT, Duration.class);
    }
}

