/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.kudu.RowHelper;
import io.trino.plugin.kudu.TypeHelper;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kudu.client.KeyEncoderAccessor;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduScannerIterator;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;

public class KuduRecordCursor
implements RecordCursor {
    private final KuduScanner scanner;
    private final List<Type> columnTypes;
    private final KuduTable table;
    private final Map<Integer, Integer> fieldMapping;
    private final KuduScannerIterator kuduScannerIterator;
    private RowResult currentRow;
    private long totalBytes;
    private volatile boolean closed;

    public KuduRecordCursor(KuduScanner scanner, KuduTable table, List<Type> columnTypes, Map<Integer, Integer> fieldMapping) {
        this.scanner = Objects.requireNonNull(scanner, "scanner is null");
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.table = Objects.requireNonNull(table, "table is null");
        this.fieldMapping = ImmutableMap.copyOf(Objects.requireNonNull(fieldMapping, "fieldMapping is null"));
        this.kuduScannerIterator = scanner.iterator();
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        return this.columnTypes.get(field);
    }

    private int mapping(int field) {
        return this.fieldMapping.get(field);
    }

    public boolean advanceNextPosition() {
        if (!this.kuduScannerIterator.hasNext()) {
            this.closed = this.scanner.isClosed();
            return false;
        }
        this.currentRow = this.kuduScannerIterator.next();
        this.totalBytes += (long)this.getRowLength();
        return true;
    }

    private int getRowLength() {
        return this.currentRow.getSchema().getRowSize();
    }

    public boolean getBoolean(int field) {
        int index = this.mapping(field);
        return TypeHelper.getBoolean(this.columnTypes.get(field), this.currentRow, index);
    }

    public long getLong(int field) {
        int index = this.mapping(field);
        return TypeHelper.getLong(this.columnTypes.get(field), this.currentRow, index);
    }

    public double getDouble(int field) {
        int index = this.mapping(field);
        return TypeHelper.getDouble(this.columnTypes.get(field), this.currentRow, index);
    }

    public Slice getSlice(int field) {
        int index = this.mapping(field);
        if (index == -1) {
            PartialRow partialRow = this.buildPrimaryKey();
            return Slices.wrappedBuffer((byte[])KeyEncoderAccessor.encodePrimaryKey(partialRow));
        }
        return TypeHelper.getSlice(this.columnTypes.get(field), this.currentRow, index);
    }

    public Object getObject(int field) {
        int index = this.mapping(field);
        return TypeHelper.getObject(this.columnTypes.get(field), this.currentRow, index);
    }

    public boolean isNull(int field) {
        int mappedField = this.mapping(field);
        return mappedField >= 0 && this.currentRow.isNull(mappedField);
    }

    private PartialRow buildPrimaryKey() {
        PartialRow row = new PartialRow(this.table.getSchema());
        RowHelper.copyPrimaryKey(this.table.getSchema(), this.currentRow, row);
        return row;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.scanner.close();
            }
            catch (KuduException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.currentRow = null;
                this.closed = true;
            }
        }
    }
}

