/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"kudu.client.default-socket-read-timeout"})
public class KuduClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private List<String> masterAddresses = ImmutableList.of();
    private Duration defaultAdminOperationTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private Duration defaultOperationTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private boolean disableStatistics;
    private boolean schemaEmulationEnabled;
    private String schemaEmulationPrefix = "presto::";
    private Duration dynamicFilteringWaitTimeout = new Duration(0.0, TimeUnit.MINUTES);
    private boolean allowLocalScheduling;

    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getMasterAddresses() {
        return this.masterAddresses;
    }

    @Config(value="kudu.client.master-addresses")
    public KuduClientConfig setMasterAddresses(String commaSeparatedList) {
        this.masterAddresses = SPLITTER.splitToList((CharSequence)commaSeparatedList);
        return this;
    }

    public KuduClientConfig setMasterAddresses(String ... contactPoints) {
        this.masterAddresses = ImmutableList.copyOf((Object[])contactPoints);
        return this;
    }

    @Config(value="kudu.client.default-admin-operation-timeout")
    public KuduClientConfig setDefaultAdminOperationTimeout(Duration timeout) {
        this.defaultAdminOperationTimeout = timeout;
        return this;
    }

    @MinDuration(value="1s")
    @MaxDuration(value="1h")
    public @MinDuration(value="1s") @MaxDuration(value="1h") Duration getDefaultAdminOperationTimeout() {
        return this.defaultAdminOperationTimeout;
    }

    @Config(value="kudu.client.default-operation-timeout")
    public KuduClientConfig setDefaultOperationTimeout(Duration timeout) {
        this.defaultOperationTimeout = timeout;
        return this;
    }

    @MinDuration(value="1s")
    @MaxDuration(value="1h")
    public @MinDuration(value="1s") @MaxDuration(value="1h") Duration getDefaultOperationTimeout() {
        return this.defaultOperationTimeout;
    }

    public boolean isDisableStatistics() {
        return this.disableStatistics;
    }

    @Config(value="kudu.client.disable-statistics")
    public KuduClientConfig setDisableStatistics(boolean disableStatistics) {
        this.disableStatistics = disableStatistics;
        return this;
    }

    public String getSchemaEmulationPrefix() {
        return this.schemaEmulationPrefix;
    }

    @Config(value="kudu.schema-emulation.prefix")
    public KuduClientConfig setSchemaEmulationPrefix(String prefix) {
        this.schemaEmulationPrefix = prefix;
        return this;
    }

    public boolean isSchemaEmulationEnabled() {
        return this.schemaEmulationEnabled;
    }

    @Config(value="kudu.schema-emulation.enabled")
    public KuduClientConfig setSchemaEmulationEnabled(boolean enabled) {
        this.schemaEmulationEnabled = enabled;
        return this;
    }

    @MinDuration(value="0ms")
    @NotNull
    public @MinDuration(value="0ms") @NotNull Duration getDynamicFilteringWaitTimeout() {
        return this.dynamicFilteringWaitTimeout;
    }

    @Config(value="kudu.dynamic-filtering.wait-timeout")
    @ConfigDescription(value="Duration to wait for completion of dynamic filters")
    public KuduClientConfig setDynamicFilteringWaitTimeout(Duration dynamicFilteringWaitTimeout) {
        this.dynamicFilteringWaitTimeout = dynamicFilteringWaitTimeout;
        return this;
    }

    public boolean isAllowLocalScheduling() {
        return this.allowLocalScheduling;
    }

    @Config(value="kudu.allow-local-scheduling")
    @ConfigDescription(value="Assign Kudu splits to replica host if worker and kudu share the same cluster")
    public KuduClientConfig setAllowLocalScheduling(boolean allowLocalScheduling) {
        this.allowLocalScheduling = allowLocalScheduling;
        return this;
    }
}

