/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KeyEncoderAccessor;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.PartitionSchema;

public class KuduBucketFunction
implements BucketFunction {
    private final List<Integer> bucketChannels;
    private final List<Type> bucketChannelTypes;
    private final List<PartitionSchema.HashBucketSchema> hashBucketSchemas;
    private final Schema schema;

    KuduBucketFunction(List<Integer> bucketChannels, List<Type> bucketChannelTypes, KuduTable kuduTable) {
        this.bucketChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketChannels));
        this.bucketChannelTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketChannelTypes));
        Preconditions.checkArgument((bucketChannels.size() == bucketChannelTypes.size() ? 1 : 0) != 0);
        this.hashBucketSchemas = kuduTable.getPartitionSchema().getHashBucketSchemas();
        this.schema = kuduTable.getSchema();
    }

    public int getBucket(Page page, int position) {
        Preconditions.checkArgument((this.bucketChannelTypes.size() == page.getChannelCount() ? 1 : 0) != 0);
        PartialRow partialRow = new PartialRow(this.schema);
        List bucketIds = (List)this.hashBucketSchemas.stream().map(hashBucketSchema -> this.calculateSchemaLevelBucketId(page, partialRow, (PartitionSchema.HashBucketSchema)hashBucketSchema, position)).collect(ImmutableList.toImmutableList());
        return KuduBucketFunction.getBucket(bucketIds, this.hashBucketSchemas);
    }

    static int getBucket(List<Integer> bucketIds, List<PartitionSchema.HashBucketSchema> hashBucketSchemas) {
        int bucketId = 0;
        for (int i = 0; i < bucketIds.size(); ++i) {
            int dimensionBucket = 1;
            for (int j = 0; j < i; ++j) {
                dimensionBucket *= hashBucketSchemas.get(j).getNumBuckets();
            }
            bucketId += (dimensionBucket *= bucketIds.get(i).intValue());
        }
        return bucketId;
    }

    private int calculateSchemaLevelBucketId(Page page, PartialRow partialRow, PartitionSchema.HashBucketSchema hashBucketSchema, int position) {
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            Block block = page.getBlock(channel);
            Type type = this.bucketChannelTypes.get(channel);
            Integer bucketChannel = this.bucketChannels.get(channel);
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                partialRow.addBoolean(bucketChannel.intValue(), BooleanType.BOOLEAN.getBoolean(block, position));
                continue;
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                partialRow.addLong(bucketChannel.intValue(), type.getLong(block, position));
                continue;
            }
            if (IntegerType.INTEGER.equals((Object)type)) {
                partialRow.addInt(bucketChannel.intValue(), Math.toIntExact(type.getLong(block, position)));
                continue;
            }
            if (SmallintType.SMALLINT.equals((Object)type)) {
                partialRow.addShort(bucketChannel.intValue(), Shorts.checkedCast((long)type.getLong(block, position)));
                continue;
            }
            if (TinyintType.TINYINT.equals((Object)type)) {
                partialRow.addByte(bucketChannel.intValue(), SignedBytes.checkedCast((long)type.getLong(block, position)));
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)type)) {
                partialRow.addDouble(bucketChannel.intValue(), type.getDouble(block, position));
                continue;
            }
            if (VarcharType.VARCHAR.equals((Object)type)) {
                partialRow.addString(bucketChannel.intValue(), type.getSlice(block, position).toStringUtf8());
                continue;
            }
            throw new UnsupportedOperationException("Grouped execution is not supported for type: " + type);
        }
        return KeyEncoderAccessor.getHashBucket(partialRow, hashBucketSchema);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucketChannels", this.bucketChannels).toString();
    }
}

