/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import io.trino.matching.Pattern;
import io.trino.matching.Property;
import io.trino.plugin.pinot.query.PinotTransformFunctionTypeResolver;
import java.util.List;
import java.util.Optional;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class PinotPatterns {
    public static final String WILDCARD = "*";

    private PinotPatterns() {
    }

    public static Pattern<FilterContext> filter() {
        return Pattern.typeOf(FilterContext.class);
    }

    public static Pattern<Predicate> predicate() {
        return Pattern.typeOf(Predicate.class);
    }

    public static Pattern<ExpressionContext> expression() {
        return Pattern.typeOf(ExpressionContext.class);
    }

    public static Pattern<FunctionContext> function() {
        return Pattern.typeOf(FunctionContext.class);
    }

    public static Pattern<FunctionContext> transformFunction() {
        return PinotPatterns.function().with(PinotPatterns.functionType().equalTo((Object)FunctionContext.Type.TRANSFORM));
    }

    public static Pattern<FunctionContext> aggregationFunction() {
        return PinotPatterns.function().with(PinotPatterns.functionType().equalTo((Object)FunctionContext.Type.AGGREGATION));
    }

    public static Pattern<FunctionContext> binaryFunction() {
        return PinotPatterns.transformFunction().with(PinotPatterns.arguments().matching(arguments -> arguments.size() == 2));
    }

    public static Property<FilterContext, ?, FilterContext.Type> filterType() {
        return Property.property((String)"filterContextType", FilterContext::getType);
    }

    public static Property<FilterContext, ?, List<FilterContext>> childFilters() {
        return Property.optionalProperty((String)"childFilters", context -> {
            if (context.getType() == FilterContext.Type.AND || context.getType() == FilterContext.Type.OR) {
                return Optional.ofNullable(context.getChildren());
            }
            return Optional.empty();
        });
    }

    public static Property<FilterContext, ?, Predicate> filterPredicate() {
        return Property.optionalProperty((String)"filterPredicate", context -> {
            if (context.getType() == FilterContext.Type.PREDICATE) {
                return Optional.ofNullable(context.getPredicate());
            }
            return Optional.empty();
        });
    }

    public static Property<Predicate, ?, Predicate.Type> predicateType() {
        return Property.property((String)"predicateType", Predicate::getType);
    }

    public static Property<Predicate, ?, ExpressionContext> predicateExpression() {
        return Property.property((String)"predicateType", Predicate::getLhs);
    }

    public static Property<Predicate, ?, String> binaryOperatorValue() {
        return Property.optionalProperty((String)"binaryOperatorValue", predicate -> {
            switch (predicate.getType()) {
                case EQ: {
                    return Optional.of(((EqPredicate)predicate).getValue());
                }
                case NOT_EQ: {
                    return Optional.of(((NotEqPredicate)predicate).getValue());
                }
                case RANGE: {
                    RangePredicate rangePredicate = (RangePredicate)predicate;
                    if (rangePredicate.getLowerBound().equals(WILDCARD)) {
                        return Optional.of(rangePredicate.getUpperBound());
                    }
                    if (rangePredicate.getUpperBound().equals(WILDCARD)) {
                        return Optional.of(rangePredicate.getLowerBound());
                    }
                    return Optional.empty();
                }
            }
            return Optional.empty();
        });
    }

    public static Property<Predicate, ?, String> binaryOperator() {
        return Property.optionalProperty((String)"binaryOperator", predicate -> {
            switch (predicate.getType()) {
                case EQ: {
                    return Optional.of("=");
                }
                case NOT_EQ: {
                    return Optional.of("!=");
                }
                case RANGE: {
                    RangePredicate rangePredicate = (RangePredicate)predicate;
                    if (rangePredicate.getLowerBound().equals(WILDCARD)) {
                        if (rangePredicate.isUpperInclusive()) {
                            return Optional.of("<=");
                        }
                        return Optional.of("<");
                    }
                    if (rangePredicate.getUpperBound().equals(WILDCARD)) {
                        if (rangePredicate.isLowerInclusive()) {
                            return Optional.of(">=");
                        }
                        return Optional.of(">");
                    }
                    return Optional.empty();
                }
            }
            return Optional.empty();
        });
    }

    public static Property<Predicate, ?, List<String>> predicateValuesList() {
        return Property.optionalProperty((String)"predicateValuesList", predicate -> {
            if (predicate.getType() == Predicate.Type.IN) {
                return Optional.of(((InPredicate)predicate).getValues());
            }
            if (predicate.getType() == Predicate.Type.NOT_IN) {
                return Optional.of(((NotInPredicate)predicate).getValues());
            }
            return Optional.empty();
        });
    }

    public static Property<Predicate, ?, String> binaryFunctionPredicateValue() {
        return Property.optionalProperty((String)"binaryFunctionPredicateValue", predicate -> {
            switch (predicate.getType()) {
                case REGEXP_LIKE: {
                    return Optional.of(((RegexpLikePredicate)predicate).getValue());
                }
                case TEXT_MATCH: {
                    return Optional.of(((TextMatchPredicate)predicate).getValue());
                }
                case JSON_MATCH: {
                    return Optional.of(((JsonMatchPredicate)predicate).getValue());
                }
            }
            return Optional.empty();
        });
    }

    public static Property<ExpressionContext, ?, FunctionContext> functionContext() {
        return Property.optionalProperty((String)"functionContext", expressionContext -> {
            if (expressionContext.getType() == ExpressionContext.Type.FUNCTION) {
                return Optional.of(expressionContext.getFunction());
            }
            return Optional.empty();
        });
    }

    public static Property<ExpressionContext, ?, ExpressionContext.Type> expressionType() {
        return Property.property((String)"expressionType", ExpressionContext::getType);
    }

    public static Property<ExpressionContext, ?, String> identifier() {
        return Property.optionalProperty((String)"identifier", expressionContext -> {
            if (expressionContext.getType() == ExpressionContext.Type.IDENTIFIER) {
                return Optional.of(expressionContext.getIdentifier());
            }
            return Optional.empty();
        });
    }

    public static Property<FunctionContext, ?, TransformFunctionType> transformFunctionType() {
        return Property.optionalProperty((String)"transformFunctionType", functionContext -> {
            if (functionContext.getType() == FunctionContext.Type.TRANSFORM) {
                return PinotTransformFunctionTypeResolver.getTransformFunctionType(functionContext);
            }
            return Optional.empty();
        });
    }

    public static Property<FunctionContext, ?, String> transformFunctionName() {
        return Property.optionalProperty((String)"transformFunctionType", functionContext -> {
            if (functionContext.getType() == FunctionContext.Type.TRANSFORM) {
                return Optional.of(functionContext.getFunctionName());
            }
            return Optional.empty();
        });
    }

    public static Property<FunctionContext, ?, AggregationFunctionType> aggregationFunctionType() {
        return Property.optionalProperty((String)"aggregationFunctionType", functionContext -> {
            if (functionContext.getType() == FunctionContext.Type.AGGREGATION) {
                return Optional.of(AggregationFunctionType.getAggregationFunctionType((String)functionContext.getFunctionName()));
            }
            return Optional.empty();
        });
    }

    public static Property<FunctionContext, ?, FunctionContext.Type> functionType() {
        return Property.property((String)"functionType", FunctionContext::getType);
    }

    public static Property<FunctionContext, ?, List<ExpressionContext>> arguments() {
        return Property.property((String)"arguments", FunctionContext::getArguments);
    }

    public static Property<FunctionContext, ?, ExpressionContext> singleInput() {
        return Property.optionalProperty((String)"singleInput", functionContext -> {
            if (functionContext.getArguments().size() == 1) {
                return Optional.of((ExpressionContext)functionContext.getArguments().get(0));
            }
            return Optional.empty();
        });
    }

    public static Property<FunctionContext, ?, ExpressionContext> firstArgument() {
        return Property.optionalProperty((String)"firstArgument", functionContext -> {
            if (!functionContext.getArguments().isEmpty()) {
                return Optional.of((ExpressionContext)functionContext.getArguments().get(0));
            }
            return Optional.empty();
        });
    }

    public static Property<FunctionContext, ?, ExpressionContext> secondArgument() {
        return Property.optionalProperty((String)"secondArgument", functionContext -> {
            if (functionContext.getArguments().size() > 1) {
                return Optional.of((ExpressionContext)functionContext.getArguments().get(1));
            }
            return Optional.empty();
        });
    }
}

