/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.DynamicTablePqlExtractor;
import java.util.Objects;

public class AggregateExpression {
    private final String function;
    private final String argument;
    private final boolean returnNullOnEmptyGroup;

    public static AggregateExpression replaceIdentifier(AggregateExpression aggregationExpression, PinotColumnHandle columnHandle) {
        return new AggregateExpression(aggregationExpression.getFunction(), AggregateExpression.stripDoubleQuotes(columnHandle.getExpression()), aggregationExpression.isReturnNullOnEmptyGroup());
    }

    private static String stripDoubleQuotes(String expression) {
        Preconditions.checkState((expression.startsWith("\"") && expression.endsWith("\"") && expression.length() >= 3 ? 1 : 0) != 0, (Object)"expression is not enclosed in double quotes");
        return expression.substring(1, expression.length() - 1).replaceAll("\"\"", "\"");
    }

    @JsonCreator
    public AggregateExpression(@JsonProperty String function, @JsonProperty String argument, @JsonProperty boolean returnNullOnEmptyGroup) {
        this.function = Objects.requireNonNull(function, "function is null");
        this.argument = Objects.requireNonNull(argument, "argument is null");
        this.returnNullOnEmptyGroup = returnNullOnEmptyGroup;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @JsonProperty
    public String getArgument() {
        return this.argument;
    }

    @JsonProperty
    public boolean isReturnNullOnEmptyGroup() {
        return this.returnNullOnEmptyGroup;
    }

    public String toFieldName() {
        return String.format("%s(%s)", this.function, this.argument);
    }

    public String toExpression() {
        return String.format("%s(%s)", this.function, DynamicTablePqlExtractor.quoteIdentifier(this.argument));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggregateExpression)) {
            return false;
        }
        AggregateExpression that = (AggregateExpression)other;
        return that.function.equals(this.function) && that.argument.equals(this.argument) && that.returnNullOnEmptyGroup == this.returnNullOnEmptyGroup;
    }

    public int hashCode() {
        return Objects.hash(this.function, this.argument, this.returnNullOnEmptyGroup);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("function", (Object)this.function).add("argument", (Object)this.argument).add("returnNullOnEmptyGroup", this.returnNullOnEmptyGroup).toString();
    }
}

