/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.decoders;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.pinot.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import java.util.function.Supplier;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class VarbinaryDecoder
implements Decoder {
    @Override
    public void decode(Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof String) {
            Slice slice = Slices.wrappedBuffer((byte[])VarbinaryDecoder.toBytes((String)value));
            ((VariableWidthBlockBuilder)output).writeEntry(slice);
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a string value of type VARBINARY: %s [%s]", value, value.getClass().getSimpleName()));
        }
    }

    public static byte[] toBytes(String stringValue) {
        try {
            return Hex.decodeHex((char[])stringValue.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Value: " + stringValue + " is not Hex encoded", e);
        }
    }
}

