/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.client;

import com.google.common.collect.ImmutableList;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import io.trino.plugin.pinot.client.PinotKeystoreTrustStoreType;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.Optional;

public class PinotGrpcServerQueryClientTlsConfig {
    private PinotKeystoreTrustStoreType keystoreType = PinotKeystoreTrustStoreType.JKS;
    private File keystorePath;
    private String keystorePassword;
    private PinotKeystoreTrustStoreType truststoreType = PinotKeystoreTrustStoreType.JKS;
    private File truststorePath;
    private String truststorePassword;
    private String sslProvider = "JDK";

    @NotNull
    public PinotKeystoreTrustStoreType getKeystoreType() {
        return this.keystoreType;
    }

    @Config(value="pinot.grpc.tls.keystore-type")
    public PinotGrpcServerQueryClientTlsConfig setKeystoreType(PinotKeystoreTrustStoreType keystoreType) {
        this.keystoreType = keystoreType;
        return this;
    }

    public Optional<@FileExists File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="pinot.grpc.tls.keystore-path")
    public PinotGrpcServerQueryClientTlsConfig setKeystorePath(File keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="pinot.grpc.tls.keystore-password")
    @ConfigSecuritySensitive
    public PinotGrpcServerQueryClientTlsConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    @NotNull
    public PinotKeystoreTrustStoreType getTruststoreType() {
        return this.truststoreType;
    }

    @Config(value="pinot.grpc.tls.truststore-type")
    public PinotGrpcServerQueryClientTlsConfig setTruststoreType(PinotKeystoreTrustStoreType truststoreType) {
        this.truststoreType = truststoreType;
        return this;
    }

    public Optional<@FileExists File> getTruststorePath() {
        return Optional.ofNullable(this.truststorePath);
    }

    @Config(value="pinot.grpc.tls.truststore-path")
    public PinotGrpcServerQueryClientTlsConfig setTruststorePath(File truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="pinot.grpc.tls.truststore-password")
    @ConfigSecuritySensitive
    public PinotGrpcServerQueryClientTlsConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    @NotNull
    public String getSslProvider() {
        return this.sslProvider;
    }

    @Config(value="pinot.grpc.tls.ssl-provider")
    public PinotGrpcServerQueryClientTlsConfig setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
        return this;
    }

    @PostConstruct
    public void validate() {
        if (this.getKeystorePath().isPresent() && this.getKeystorePassword().isEmpty()) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("pinot.grpc.tls.keystore-password must set when pinot.grpc.tls.keystore-path is given")));
        }
        if (this.getTruststorePath().isPresent() && this.getTruststorePassword().isEmpty()) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("pinot.grpc.tls.truststore-password must set when pinot.grpc.tls.truststore-path is given")));
        }
    }
}

