/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.client;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotSplit;
import io.trino.plugin.pinot.client.PinotDataFetcher;
import io.trino.plugin.pinot.client.PinotDataTableWithSize;
import io.trino.plugin.pinot.client.PinotGrpcServerQueryClientConfig;
import io.trino.plugin.pinot.client.PinotGrpcServerQueryClientTlsConfig;
import io.trino.plugin.pinot.client.PinotHostMapper;
import io.trino.plugin.pinot.query.PinotProxyGrpcRequestBuilder;
import io.trino.spi.connector.ConnectorSession;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.common.config.GrpcConfig;
import org.apache.pinot.common.datatable.DataTableFactory;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.grpc.GrpcQueryClient;

public class PinotGrpcDataFetcher
implements PinotDataFetcher {
    private final PinotSplit split;
    private final PinotGrpcServerQueryClient pinotGrpcClient;
    private final String query;
    private long readTimeNanos;
    private Iterator<PinotDataTableWithSize> responseIterator;
    private boolean isPinotDataFetched;
    private final PinotDataFetcher.RowCountChecker rowCountChecker;
    private long estimatedMemoryUsageInBytes;

    public PinotGrpcDataFetcher(PinotGrpcServerQueryClient pinotGrpcClient, PinotSplit split, String query, PinotDataFetcher.RowCountChecker rowCountChecker) {
        this.pinotGrpcClient = Objects.requireNonNull(pinotGrpcClient, "pinotGrpcClient is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.rowCountChecker = Objects.requireNonNull(rowCountChecker, "rowCountChecker is null");
    }

    @Override
    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public long getMemoryUsageBytes() {
        return this.estimatedMemoryUsageInBytes;
    }

    @Override
    public boolean endOfData() {
        return !this.responseIterator.hasNext();
    }

    @Override
    public boolean isDataFetched() {
        return this.isPinotDataFetched;
    }

    @Override
    public void fetchData() {
        long startTimeNanos = System.nanoTime();
        String serverHost = this.split.getSegmentHost().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), "Expected the segment split to contain the host"));
        this.responseIterator = this.pinotGrpcClient.queryPinot(null, this.query, serverHost, this.split.getSegments());
        this.readTimeNanos += System.nanoTime() - startTimeNanos;
        this.isPinotDataFetched = true;
    }

    @Override
    public PinotDataTableWithSize getNextDataTable() {
        PinotDataTableWithSize dataTableWithSize = this.responseIterator.next();
        this.estimatedMemoryUsageInBytes = dataTableWithSize.getEstimatedSizeInBytes();
        this.rowCountChecker.checkTooManyRows(dataTableWithSize.getDataTable());
        this.checkExceptions(dataTableWithSize.getDataTable(), this.split, this.query);
        return dataTableWithSize;
    }

    public static class PinotGrpcServerQueryClient {
        private final PinotHostMapper pinotHostMapper;
        private final Map<HostAndPort, GrpcQueryClient> clientCache = new ConcurrentHashMap<HostAndPort, GrpcQueryClient>();
        private final int grpcPort;
        private final GrpcQueryClientFactory grpcQueryClientFactory;
        private final Optional<String> proxyUri;
        private final Closer closer;

        private PinotGrpcServerQueryClient(PinotHostMapper pinotHostMapper, PinotGrpcServerQueryClientConfig pinotGrpcServerQueryClientConfig, GrpcQueryClientFactory grpcQueryClientFactory, Closer closer) {
            this.pinotHostMapper = Objects.requireNonNull(pinotHostMapper, "pinotHostMapper is null");
            Objects.requireNonNull(pinotGrpcServerQueryClientConfig, "pinotGrpcServerQueryClientConfig is null");
            this.grpcPort = pinotGrpcServerQueryClientConfig.getGrpcPort();
            this.grpcQueryClientFactory = Objects.requireNonNull(grpcQueryClientFactory, "grpcQueryClientFactory is null");
            this.closer = Objects.requireNonNull(closer, "closer is null");
            this.proxyUri = pinotGrpcServerQueryClientConfig.getProxyUri();
        }

        public Iterator<PinotDataTableWithSize> queryPinot(ConnectorSession session, String query, String serverHost, List<String> segments) {
            HostAndPort mappedHostAndPort = this.pinotHostMapper.getServerGrpcHostAndPort(serverHost, this.grpcPort);
            GrpcQueryClient client = this.clientCache.computeIfAbsent(mappedHostAndPort, hostAndPort -> {
                GrpcQueryClient queryClient = this.proxyUri.isPresent() ? this.grpcQueryClientFactory.create(HostAndPort.fromString((String)this.proxyUri.get())) : this.grpcQueryClientFactory.create((HostAndPort)hostAndPort);
                this.closer.register(() -> ((GrpcQueryClient)queryClient).close());
                return queryClient;
            });
            PinotProxyGrpcRequestBuilder grpcRequestBuilder = new PinotProxyGrpcRequestBuilder().setSql(query).setSegments(segments).setEnableStreaming(true);
            if (this.proxyUri.isPresent()) {
                grpcRequestBuilder.setHostName(mappedHostAndPort.getHost()).setPort(this.grpcPort);
            }
            Server.ServerRequest serverRequest = grpcRequestBuilder.build();
            return new ResponseIterator(client.submit(serverRequest));
        }

        public static class ResponseIterator
        extends AbstractIterator<PinotDataTableWithSize> {
            private final Iterator<Server.ServerResponse> responseIterator;

            public ResponseIterator(Iterator<Server.ServerResponse> responseIterator) {
                this.responseIterator = Objects.requireNonNull(responseIterator, "responseIterator is null");
            }

            protected PinotDataTableWithSize computeNext() {
                if (!this.responseIterator.hasNext()) {
                    return (PinotDataTableWithSize)this.endOfData();
                }
                Server.ServerResponse response = this.responseIterator.next();
                String responseType = (String)response.getMetadataMap().get("responseType");
                if (responseType.equals("metadata")) {
                    return (PinotDataTableWithSize)this.endOfData();
                }
                ByteBuffer buffer = response.getPayload().asReadOnlyByteBuffer();
                try {
                    return new PinotDataTableWithSize(DataTableFactory.getDataTable((ByteBuffer)buffer), buffer.remaining());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    public static class TlsGrpcQueryClientFactory
    implements GrpcQueryClientFactory {
        private static final String KEYSTORE_TYPE = "tls.keystore.type";
        private static final String KEYSTORE_PATH = "tls.keystore.path";
        private static final String KEYSTORE_PASSWORD = "tls.keystore.password";
        private static final String TRUSTSTORE_TYPE = "tls.truststore.type";
        private static final String TRUSTSTORE_PATH = "tls.truststore.path";
        private static final String TRUSTSTORE_PASSWORD = "tls.truststore.password";
        private static final String SSL_PROVIDER = "tls.ssl.provider";
        private final GrpcConfig config;

        @Inject
        public TlsGrpcQueryClientFactory(PinotGrpcServerQueryClientConfig grpcClientConfig, PinotGrpcServerQueryClientTlsConfig tlsConfig) {
            Objects.requireNonNull(grpcClientConfig, "grpcClientConfig is null");
            Objects.requireNonNull(tlsConfig, "tlsConfig is null");
            ImmutableMap.Builder tlsConfigBuilder = ImmutableMap.builder().put((Object)"maxInboundMessageSizeBytes", (Object)String.valueOf(grpcClientConfig.getMaxInboundMessageSize().toBytes())).put((Object)"usePlainText", (Object)Boolean.FALSE.toString());
            if (tlsConfig.getKeystorePath().isPresent()) {
                tlsConfigBuilder.put((Object)KEYSTORE_TYPE, (Object)tlsConfig.getKeystoreType());
                tlsConfigBuilder.put((Object)KEYSTORE_PATH, (Object)tlsConfig.getKeystorePath().get());
                tlsConfig.getKeystorePassword().ifPresent(password -> tlsConfigBuilder.put((Object)KEYSTORE_PASSWORD, password));
            }
            if (tlsConfig.getTruststorePath().isPresent()) {
                tlsConfigBuilder.put((Object)TRUSTSTORE_TYPE, (Object)tlsConfig.getTruststoreType());
                tlsConfigBuilder.put((Object)TRUSTSTORE_PATH, (Object)tlsConfig.getTruststorePath().get());
                tlsConfig.getTruststorePassword().ifPresent(password -> tlsConfigBuilder.put((Object)TRUSTSTORE_PASSWORD, password));
            }
            tlsConfigBuilder.put((Object)SSL_PROVIDER, (Object)tlsConfig.getSslProvider());
            this.config = new GrpcConfig((Map)tlsConfigBuilder.buildOrThrow());
        }

        @Override
        public GrpcQueryClient create(HostAndPort hostAndPort) {
            return new GrpcQueryClient(hostAndPort.getHost(), hostAndPort.getPort(), this.config);
        }
    }

    public static class PlainTextGrpcQueryClientFactory
    implements GrpcQueryClientFactory {
        private final GrpcConfig config;

        @Inject
        public PlainTextGrpcQueryClientFactory(PinotGrpcServerQueryClientConfig grpcClientConfig) {
            Objects.requireNonNull(grpcClientConfig, "grpcClientConfig is null");
            this.config = new GrpcConfig((Map)ImmutableMap.builder().put((Object)"maxInboundMessageSizeBytes", (Object)String.valueOf(grpcClientConfig.getMaxInboundMessageSize().toBytes())).put((Object)"usePlainText", (Object)String.valueOf(grpcClientConfig.isUsePlainText())).buildOrThrow());
        }

        @Override
        public GrpcQueryClient create(HostAndPort hostAndPort) {
            return new GrpcQueryClient(hostAndPort.getHost(), hostAndPort.getPort(), this.config);
        }
    }

    public static interface GrpcQueryClientFactory {
        public GrpcQueryClient create(HostAndPort var1);
    }

    public static class Factory
    implements PinotDataFetcher.Factory {
        private final PinotGrpcServerQueryClient queryClient;
        private final int limitForSegmentQueries;
        private final Closer closer = Closer.create();

        @Inject
        public Factory(PinotHostMapper pinotHostMapper, PinotGrpcServerQueryClientConfig pinotGrpcServerQueryClientConfig, GrpcQueryClientFactory grpcQueryClientFactory) {
            Objects.requireNonNull(pinotHostMapper, "pinotHostMapper is null");
            this.limitForSegmentQueries = pinotGrpcServerQueryClientConfig.getMaxRowsPerSplitForSegmentQueries();
            this.queryClient = new PinotGrpcServerQueryClient(pinotHostMapper, pinotGrpcServerQueryClientConfig, grpcQueryClientFactory, this.closer);
        }

        @PreDestroy
        public void shutdown() throws IOException {
            this.closer.close();
        }

        @Override
        public PinotDataFetcher create(ConnectorSession session, String query, PinotSplit split) {
            return new PinotGrpcDataFetcher(this.queryClient, split, query, new PinotDataFetcher.RowCountChecker(this.limitForSegmentQueries, query));
        }

        @Override
        public int getRowLimit() {
            return this.limitForSegmentQueries;
        }
    }
}

