/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.pinot.PinotConnector;
import io.trino.plugin.pinot.PinotModule;
import io.trino.plugin.pinot.auth.PinotAuthenticationModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.weakref.jmx.guice.MBeanModule;

public class PinotConnectorFactory
implements ConnectorFactory {
    private final Optional<Module> extension;

    public PinotConnectorFactory(Optional<Module> extension) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
    }

    public String getName() {
        return "pinot";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        ImmutableList.Builder modulesBuilder = ImmutableList.builder().add((Object)new JsonModule()).add((Object)new MBeanModule()).add((Object)new TypeDeserializerModule(context.getTypeManager())).add((Object)new PinotModule(catalogName, context.getNodeManager())).add((Object)new PinotAuthenticationModule());
        this.extension.ifPresent(arg_0 -> ((ImmutableList.Builder)modulesBuilder).add(arg_0));
        Bootstrap app = new Bootstrap((Iterable)modulesBuilder.build());
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(PinotConnector.class);
    }
}

