/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"pinot.thread-pool-size", "pinot.idle-timeout", "pinot.max-backlog-per-server", "pinot.max-connections-per-server", "pinot.min-connections-per-server", "pinot.request-timeout"})
public class PinotConfig {
    private static final Splitter LIST_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private List<URI> controllerUrls = ImmutableList.of();
    private Duration connectionTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private int estimatedSizeInBytesForNonNumericColumn = 20;
    private Duration metadataCacheExpiry = new Duration(2.0, TimeUnit.MINUTES);
    private boolean preferBrokerQueries;
    private boolean forbidSegmentQueries;
    private int segmentsPerSplit = 1;
    private int fetchRetryCount = 2;
    private int nonAggregateLimitForBrokerQueries = 25000;
    private int maxRowsForBrokerQueries = 50000;
    private boolean aggregationPushdownEnabled = true;
    private boolean countDistinctPushdownEnabled = true;
    private boolean grpcEnabled = true;
    private boolean proxyEnabled;
    private DataSize targetSegmentPageSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    @NotEmpty(message="pinot.controller-urls cannot be empty")
    public @NotEmpty(message="pinot.controller-urls cannot be empty") List<URI> getControllerUrls() {
        return this.controllerUrls;
    }

    @Config(value="pinot.controller-urls")
    public PinotConfig setControllerUrls(String controllerUrl) {
        this.controllerUrls = (List)LIST_SPLITTER.splitToList((CharSequence)controllerUrl).stream().map(PinotConfig::stringToUri).collect(ImmutableList.toImmutableList());
        return this;
    }

    @MinDuration(value="15s")
    @NotNull
    public @MinDuration(value="15s") @NotNull Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="pinot.connection-timeout")
    public PinotConfig setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @MinDuration(value="0s")
    @NotNull
    public @MinDuration(value="0s") @NotNull Duration getMetadataCacheExpiry() {
        return this.metadataCacheExpiry;
    }

    @Config(value="pinot.metadata-expiry")
    public PinotConfig setMetadataCacheExpiry(Duration metadataCacheExpiry) {
        this.metadataCacheExpiry = metadataCacheExpiry;
        return this;
    }

    @NotNull
    public int getEstimatedSizeInBytesForNonNumericColumn() {
        return this.estimatedSizeInBytesForNonNumericColumn;
    }

    @Config(value="pinot.estimated-size-in-bytes-for-non-numeric-column")
    public PinotConfig setEstimatedSizeInBytesForNonNumericColumn(int estimatedSizeInBytesForNonNumericColumn) {
        this.estimatedSizeInBytesForNonNumericColumn = estimatedSizeInBytesForNonNumericColumn;
        return this;
    }

    public boolean isPreferBrokerQueries() {
        return this.preferBrokerQueries;
    }

    @Config(value="pinot.prefer-broker-queries")
    public PinotConfig setPreferBrokerQueries(boolean preferBrokerQueries) {
        this.preferBrokerQueries = preferBrokerQueries;
        return this;
    }

    public boolean isForbidSegmentQueries() {
        return this.forbidSegmentQueries;
    }

    @Config(value="pinot.forbid-segment-queries")
    public PinotConfig setForbidSegmentQueries(boolean forbidSegmentQueries) {
        this.forbidSegmentQueries = forbidSegmentQueries;
        return this;
    }

    public int getSegmentsPerSplit() {
        return this.segmentsPerSplit;
    }

    @Config(value="pinot.segments-per-split")
    public PinotConfig setSegmentsPerSplit(int segmentsPerSplit) {
        Preconditions.checkArgument((segmentsPerSplit > 0 ? 1 : 0) != 0, (Object)"Segments per split must be greater than zero");
        this.segmentsPerSplit = segmentsPerSplit;
        return this;
    }

    public int getFetchRetryCount() {
        return this.fetchRetryCount;
    }

    @Config(value="pinot.fetch-retry-count")
    public PinotConfig setFetchRetryCount(int fetchRetryCount) {
        this.fetchRetryCount = fetchRetryCount;
        return this;
    }

    public int getNonAggregateLimitForBrokerQueries() {
        return this.nonAggregateLimitForBrokerQueries;
    }

    @Config(value="pinot.non-aggregate-limit-for-broker-queries")
    public PinotConfig setNonAggregateLimitForBrokerQueries(int nonAggregateLimitForBrokerQueries) {
        this.nonAggregateLimitForBrokerQueries = nonAggregateLimitForBrokerQueries;
        return this;
    }

    private static URI stringToUri(String server) {
        if (server.startsWith("http://") || server.startsWith("https://")) {
            return URI.create(server);
        }
        return URI.create("http://" + server);
    }

    public int getMaxRowsForBrokerQueries() {
        return this.maxRowsForBrokerQueries;
    }

    @Config(value="pinot.max-rows-for-broker-queries")
    public PinotConfig setMaxRowsForBrokerQueries(int maxRowsForBrokerQueries) {
        this.maxRowsForBrokerQueries = maxRowsForBrokerQueries;
        return this;
    }

    public boolean isAggregationPushdownEnabled() {
        return this.aggregationPushdownEnabled;
    }

    @Config(value="pinot.aggregation-pushdown.enabled")
    public PinotConfig setAggregationPushdownEnabled(boolean aggregationPushdownEnabled) {
        this.aggregationPushdownEnabled = aggregationPushdownEnabled;
        return this;
    }

    public boolean isCountDistinctPushdownEnabled() {
        return this.countDistinctPushdownEnabled;
    }

    @Config(value="pinot.count-distinct-pushdown.enabled")
    @ConfigDescription(value="Controls whether distinct count is pushed down to Pinot. Distinct count pushdown can cause Pinot to do a full scan. Aggregation pushdown must also be enabled in addition to this parameter otherwise no pushdowns will be enabled.")
    public PinotConfig setCountDistinctPushdownEnabled(boolean countDistinctPushdownEnabled) {
        this.countDistinctPushdownEnabled = countDistinctPushdownEnabled;
        return this;
    }

    public boolean isGrpcEnabled() {
        return this.grpcEnabled;
    }

    @Config(value="pinot.grpc.enabled")
    public PinotConfig setGrpcEnabled(boolean grpcEnabled) {
        this.grpcEnabled = grpcEnabled;
        return this;
    }

    public boolean isTlsEnabled() {
        return "https".equalsIgnoreCase(this.getControllerUrls().get(0).getScheme());
    }

    public boolean getProxyEnabled() {
        return this.proxyEnabled;
    }

    @Config(value="pinot.proxy.enabled")
    public PinotConfig setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
        return this;
    }

    public DataSize getTargetSegmentPageSize() {
        return this.targetSegmentPageSize;
    }

    @Config(value="pinot.target-segment-page-size")
    public PinotConfig setTargetSegmentPageSize(DataSize targetSegmentPageSize) {
        this.targetSegmentPageSize = targetSegmentPageSize;
        return this;
    }

    @PostConstruct
    public void validate() {
        Preconditions.checkState((!this.countDistinctPushdownEnabled || this.aggregationPushdownEnabled ? 1 : 0) != 0, (Object)"Invalid configuration: pinot.aggregation-pushdown.enabled must be enabled if pinot.count-distinct-pushdown.enabled");
    }

    @AssertTrue(message="All controller URLs must have the same scheme")
    public @AssertTrue(message="All controller URLs must have the same scheme") boolean allUrlSchemesEqual() {
        return this.controllerUrls.stream().map(URI::getScheme).distinct().count() == 1L;
    }

    @AssertTrue(message="Using the rest proxy requires GRPC to be enabled by setting pinot.grpc.enabled=true")
    public @AssertTrue(message="Using the rest proxy requires GRPC to be enabled by setting pinot.grpc.enabled=true") boolean proxyRestAndGrpcAreRequired() {
        if (this.proxyEnabled) {
            return this.grpcEnabled;
        }
        return true;
    }
}

