/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.base.Preconditions;
import io.trino.filesystem.s3.S3FileSystemConfig;
import java.util.Objects;
import software.amazon.awssdk.services.s3.model.RequestPayer;

record S3Context(int partSize, boolean requesterPays, S3FileSystemConfig.S3SseType sseType, String sseKmsKeyId) {
    private static final int MIN_PART_SIZE = 0x500000;

    public S3Context {
        Preconditions.checkArgument((partSize >= 0x500000 ? 1 : 0) != 0, (String)"partSize must be at least %s bytes", (int)0x500000);
        Objects.requireNonNull(sseType, "sseType is null");
        Preconditions.checkArgument((sseType != S3FileSystemConfig.S3SseType.KMS || sseKmsKeyId != null ? 1 : 0) != 0, (Object)"sseKmsKeyId is null for SSE-KMS");
    }

    public RequestPayer requestPayer() {
        return this.requesterPays ? RequestPayer.REQUESTER : null;
    }
}

