/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.session.db;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.mysql.cj.jdbc.MysqlDataSource;
import io.trino.plugin.session.db.DbSessionPropertyManagerConfig;
import io.trino.plugin.session.db.SessionPropertiesDao;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class SessionPropertiesDaoProvider
implements Provider<SessionPropertiesDao> {
    private final SessionPropertiesDao dao;

    @Inject
    public SessionPropertiesDaoProvider(DbSessionPropertyManagerConfig config) {
        String url = Objects.requireNonNull(config.getConfigDbUrl(), "db url is null");
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setURL(url);
        Optional<String> username = Optional.ofNullable(config.getUsername());
        username.ifPresent(arg_0 -> ((MysqlDataSource)dataSource).setUser(arg_0));
        Optional<String> password = Optional.ofNullable(config.getPassword());
        password.ifPresent(arg_0 -> ((MysqlDataSource)dataSource).setPassword(arg_0));
        this.dao = (SessionPropertiesDao)Jdbi.create((DataSource)dataSource).installPlugin((JdbiPlugin)new SqlObjectPlugin()).onDemand(SessionPropertiesDao.class);
    }

    public SessionPropertiesDao get() {
        return this.dao;
    }
}

