/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.lzo.LzopCodec;
import io.trino.hadoop.TextLineLengthLimitExceededException;
import io.trino.hdfs.ConfigurationUtils;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.avro.TrinoAvroSerDe;
import io.trino.plugin.hive.util.FooterAwareRecordReader;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public final class HiveReaderUtil {
    private HiveReaderUtil() {
    }

    public static RecordReader<?, ?> createRecordReader(Configuration configuration, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns) {
        List readColumns = (List)columns.stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).collect(ImmutableList.toImmutableList());
        readColumns.forEach(readColumn -> Preconditions.checkArgument((boolean)readColumn.isBaseColumn(), (String)"column %s is not a base column", (Object)readColumn.getName()));
        List readHiveColumnIndexes = (List)readColumns.stream().map(HiveColumnHandle::getBaseHiveColumnIndex).collect(ImmutableList.toImmutableList());
        configuration = ConfigurationUtils.copy((Configuration)configuration);
        HiveReaderUtil.setReadColumns(configuration, readHiveColumnIndexes);
        InputFormat<?, ?> inputFormat = HiveReaderUtil.getInputFormat(configuration, schema);
        JobConf jobConf = ConfigurationUtils.toJobConf((Configuration)configuration);
        FileSplit fileSplit = new FileSplit(path, start, length, (String[])null);
        schema.stringPropertyNames().stream().filter(name -> name.startsWith("serialization.")).forEach(name -> jobConf.set(name, schema.getProperty((String)name)));
        HiveReaderUtil.configureCompressionCodecs(jobConf);
        try {
            int footerCount;
            FooterAwareRecordReader recordReader = inputFormat.getRecordReader((InputSplit)fileSplit, jobConf, Reporter.NULL);
            int headerCount = HiveUtil.getHeaderCount(schema);
            if (start == 0L && headerCount > 0) {
                HiveReaderUtil.skipHeader(recordReader, headerCount);
            }
            if ((footerCount = HiveUtil.getFooterCount(schema)) > 0) {
                recordReader = new FooterAwareRecordReader(recordReader, footerCount, jobConf);
            }
            return recordReader;
        }
        catch (IOException e) {
            if (e instanceof TextLineLengthLimitExceededException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Line too long in text file: " + path, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, String.format("Error opening Hive split %s (offset=%s, length=%s) using %s: %s", path, start, length, HiveUtil.getInputFormatName(schema).orElse(null), MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e.getClass().getName())), (Throwable)e);
        }
    }

    private static <K, V> void skipHeader(RecordReader<K, V> reader, int headerCount) throws IOException {
        Object key = reader.createKey();
        Object value = reader.createValue();
        while (headerCount > 0) {
            if (!reader.next(key, value)) {
                return;
            }
            --headerCount;
        }
    }

    private static void setReadColumns(Configuration configuration, List<Integer> readHiveColumnIndexes) {
        configuration.set("hive.io.file.readcolumn.ids", Joiner.on((char)',').join(readHiveColumnIndexes));
        configuration.setBoolean("hive.io.file.read.all.columns", false);
    }

    private static void configureCompressionCodecs(JobConf jobConf) {
        ArrayList codecs = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)jobConf.get("io.compression.codecs", "")));
        if (!codecs.contains(LzoCodec.class.getName())) {
            codecs.add(0, LzoCodec.class.getName());
        }
        if (!codecs.contains(LzopCodec.class.getName())) {
            codecs.add(0, LzopCodec.class.getName());
        }
        jobConf.set("io.compression.codecs", String.join((CharSequence)",", codecs));
    }

    public static InputFormat<?, ?> getInputFormat(Configuration configuration, Properties schema) {
        String inputFormatName = HiveUtil.getInputFormatName(schema).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table or partition is missing Hive input format property: file.inputformat"));
        try {
            JobConf jobConf = ConfigurationUtils.toJobConf((Configuration)configuration);
            HiveReaderUtil.configureCompressionCodecs(jobConf);
            Class<InputFormat<?, ?>> inputFormatClass = HiveReaderUtil.getInputFormatClass(jobConf, inputFormatName);
            if (inputFormatClass.getName().equals("org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat")) {
                String serde = HiveUtil.getDeserializerClassName(schema);
                if (serde.equals(HiveStorageFormat.TEXTFILE.getSerde())) {
                    inputFormatClass = HiveReaderUtil.getInputFormatClass(jobConf, HiveStorageFormat.TEXTFILE.getInputFormat());
                    return (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)jobConf);
                }
                for (HiveStorageFormat format : HiveStorageFormat.values()) {
                    if (!serde.equals(format.getSerde())) continue;
                    inputFormatClass = HiveReaderUtil.getInputFormatClass(jobConf, format.getInputFormat());
                    return (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)jobConf);
                }
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Unknown SerDe for SymlinkTextInputFormat: " + serde);
            }
            return (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)jobConf);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Unable to create input format " + inputFormatName, (Throwable)e);
        }
    }

    private static Class<? extends InputFormat<?, ?>> getInputFormatClass(JobConf conf, String inputFormatName) throws ClassNotFoundException {
        if ("parquet.hive.DeprecatedParquetInputFormat".equals(inputFormatName) || "parquet.hive.MapredParquetInputFormat".equals(inputFormatName)) {
            inputFormatName = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat";
        }
        Class clazz = conf.getClassByName(inputFormatName);
        return clazz.asSubclass(InputFormat.class);
    }

    public static StructObjectInspector getTableObjectInspector(Deserializer deserializer) {
        try {
            ObjectInspector inspector = deserializer.getObjectInspector();
            Preconditions.checkArgument((inspector.getCategory() == ObjectInspector.Category.STRUCT ? 1 : 0) != 0, (String)"expected STRUCT: %s", (Object)inspector.getCategory());
            return (StructObjectInspector)inspector;
        }
        catch (SerDeException e) {
            throw new RuntimeException(e);
        }
    }

    public static Deserializer getDeserializer(Configuration configuration, Properties schema) {
        String name = HiveUtil.getDeserializerClassName(schema);
        if (name.equals("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe") && schema.containsKey("colelction.delim") && !schema.containsKey("collection.delim")) {
            schema.setProperty("collection.delim", schema.getProperty("colelction.delim"));
        }
        Deserializer deserializer = HiveReaderUtil.createDeserializer(HiveReaderUtil.getDeserializerClass(name));
        HiveReaderUtil.initializeDeserializer(configuration, deserializer, schema);
        return deserializer;
    }

    private static Class<? extends Deserializer> getDeserializerClass(String name) {
        if ("org.apache.hadoop.hive.serde2.avro.AvroSerDe".equals(name)) {
            return TrinoAvroSerDe.class;
        }
        try {
            return Class.forName(name).asSubclass(Deserializer.class);
        }
        catch (ClassNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_SERDE_NOT_FOUND, "deserializer does not exist: " + name);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("invalid deserializer class: " + name);
        }
    }

    private static Deserializer createDeserializer(Class<? extends Deserializer> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("error creating deserializer: " + clazz.getName(), e);
        }
    }

    private static void initializeDeserializer(Configuration configuration, Deserializer deserializer, Properties schema) {
        try {
            configuration = ConfigurationUtils.copy((Configuration)configuration);
            deserializer.initialize(configuration, schema);
            HiveReaderUtil.validate(deserializer);
        }
        catch (RuntimeException | SerDeException e) {
            throw new RuntimeException("error initializing deserializer: " + deserializer.getClass().getName(), e);
        }
    }

    private static void validate(Deserializer deserializer) {
        if (deserializer instanceof AbstractSerDe && !((AbstractSerDe)deserializer).getConfigurationErrors().isEmpty()) {
            throw new RuntimeException("There are configuration errors: " + ((AbstractSerDe)deserializer).getConfigurationErrors());
        }
    }
}

