/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Throwables;
import io.trino.plugin.hive.metastore.thrift.TFilterTransport;
import java.security.PrivilegedActionException;
import java.util.Objects;
import javax.security.auth.Subject;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TSubjectAssumingTransport
extends TFilterTransport {
    private final Subject subject;

    public TSubjectAssumingTransport(TTransport transport, Subject subject) {
        super(transport);
        this.subject = Objects.requireNonNull(subject, "ugi is null");
    }

    @Override
    public void open() throws TTransportException {
        try {
            Subject.doAs(this.subject, () -> {
                this.transport.open();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TTransportException.class);
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

