/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.handlers.RequestHandler2;
import java.util.Objects;

public class ProxyApiRequestHandler
extends RequestHandler2 {
    private final String proxyApiId;

    public ProxyApiRequestHandler(String proxyApiId) {
        this.proxyApiId = Objects.requireNonNull(proxyApiId, "proxyApiId is null");
    }

    public AmazonWebServiceRequest beforeExecution(AmazonWebServiceRequest request) {
        request.putCustomRequestHeader("x-apigw-api-id", this.proxyApiId);
        return request;
    }

    public void beforeRequest(Request<?> request) {
        request.getHeaders().put("X-Trino-Amz-Target-Proxy", (String)request.getHeaders().remove("X-Amz-Target"));
    }
}

