/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.trino.filesystem.TrinoInput;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import java.io.IOException;
import java.util.Objects;

final class MonitoredInput
implements TrinoInput {
    private final FileFormatDataSourceStats stats;
    private final TrinoInput delegate;

    public MonitoredInput(FileFormatDataSourceStats stats, TrinoInput delegate) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long readStart = System.nanoTime();
        this.delegate.readFully(position, buffer, bufferOffset, bufferLength);
        this.stats.readDataBytesPerSecond(bufferLength, System.nanoTime() - readStart);
    }

    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long readStart = System.nanoTime();
        int size = this.delegate.readTail(buffer, bufferOffset, bufferLength);
        this.stats.readDataBytesPerSecond(size, System.nanoTime() - readStart);
        return size;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

