/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena.projection;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.aws.athena.projection.DateProjectionFactory;
import io.trino.plugin.hive.aws.athena.projection.Projection;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class DateProjection
extends Projection {
    private final DateFormat dateFormat;
    private final Supplier<Instant> leftBound;
    private final Supplier<Instant> rightBound;
    private final int interval;
    private final ChronoUnit intervalUnit;

    public DateProjection(String columnName, DateFormat dateFormat, Supplier<Instant> leftBound, Supplier<Instant> rightBound, int interval, ChronoUnit intervalUnit) {
        super(columnName);
        this.dateFormat = Objects.requireNonNull(dateFormat, "dateFormatPattern is null");
        this.leftBound = Objects.requireNonNull(leftBound, "leftBound is null");
        this.rightBound = Objects.requireNonNull(rightBound, "rightBound is null");
        this.interval = interval;
        this.intervalUnit = Objects.requireNonNull(intervalUnit, "intervalUnit is null");
    }

    @Override
    public List<String> getProjectedValues(Optional<Domain> partitionValueFilter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Instant leftBound = this.adjustBoundToDateFormat(this.leftBound.get());
        Instant rightBound = this.adjustBoundToDateFormat(this.rightBound.get());
        Instant currentValue = leftBound;
        while (!currentValue.isAfter(rightBound)) {
            String currentValueFormatted = this.formatValue(currentValue);
            if (this.isValueInDomain(partitionValueFilter, currentValue, currentValueFormatted)) {
                builder.add((Object)currentValueFormatted);
            }
            currentValue = currentValue.atZone(DateProjectionFactory.UTC_TIME_ZONE_ID).plus(this.interval, this.intervalUnit).toInstant();
        }
        return builder.build();
    }

    private Instant adjustBoundToDateFormat(Instant value) {
        String formatted = this.formatValue(value.with(ChronoField.MILLI_OF_SECOND, 0L));
        try {
            return this.dateFormat.parse(formatted).toInstant();
        }
        catch (ParseException e) {
            throw DateProjection.invalidProjectionException(formatted, e.getMessage());
        }
    }

    private String formatValue(Instant current) {
        return this.dateFormat.format(new Date(current.toEpochMilli()));
    }

    private boolean isValueInDomain(Optional<Domain> valueDomain, Instant value, String formattedValue) {
        if (valueDomain.isEmpty() || valueDomain.get().isAll()) {
            return true;
        }
        Domain domain = valueDomain.get();
        Type type = domain.getType();
        if (type instanceof VarcharType) {
            return domain.contains(Domain.singleValue((Type)type, (Object)Slices.utf8Slice((String)formattedValue)));
        }
        if (type instanceof DateType) {
            return domain.contains(Domain.singleValue((Type)type, (Object)TimeUnit.MILLISECONDS.toDays(value.toEpochMilli())));
        }
        if (type instanceof TimestampType && ((TimestampType)type).isShort()) {
            return domain.contains(Domain.singleValue((Type)type, (Object)TimeUnit.MILLISECONDS.toMicros(value.toEpochMilli())));
        }
        throw this.unsupportedProjectionColumnTypeException(type);
    }
}

