/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;

public class TableAlreadyExistsException
extends TrinoException {
    private final SchemaTableName tableName;

    public TableAlreadyExistsException(SchemaTableName tableName) {
        this(tableName, String.format("Table already exists: '%s'", tableName));
    }

    public TableAlreadyExistsException(SchemaTableName tableName, String message) {
        this(tableName, message, null);
    }

    public TableAlreadyExistsException(SchemaTableName tableName, String message, Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, message, cause);
        this.tableName = tableName;
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

