/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

public final class HiveBooleanParser {
    private HiveBooleanParser() {
    }

    public static Boolean parseHiveBoolean(byte[] bytes, int start, int length) {
        if (HiveBooleanParser.isTrue(bytes, start, length)) {
            return true;
        }
        if (HiveBooleanParser.isFalse(bytes, start, length)) {
            return false;
        }
        return null;
    }

    public static boolean isFalse(byte[] bytes, int start, int length) {
        return length == 5 && HiveBooleanParser.toUpperCase(bytes[start + 0]) == 70 && HiveBooleanParser.toUpperCase(bytes[start + 1]) == 65 && HiveBooleanParser.toUpperCase(bytes[start + 2]) == 76 && HiveBooleanParser.toUpperCase(bytes[start + 3]) == 83 && HiveBooleanParser.toUpperCase(bytes[start + 4]) == 69;
    }

    public static boolean isTrue(byte[] bytes, int start, int length) {
        return length == 4 && HiveBooleanParser.toUpperCase(bytes[start + 0]) == 84 && HiveBooleanParser.toUpperCase(bytes[start + 1]) == 82 && HiveBooleanParser.toUpperCase(bytes[start + 2]) == 85 && HiveBooleanParser.toUpperCase(bytes[start + 3]) == 69;
    }

    private static byte toUpperCase(byte b) {
        return HiveBooleanParser.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte b) {
        return b >= 97 && b <= 122;
    }
}

