/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.orc.OrcColumn;
import io.trino.orc.StreamId;
import io.trino.orc.metadata.Stream;
import io.trino.orc.stream.InputStreamSource;
import io.trino.orc.stream.MissingInputStreamSource;
import io.trino.orc.stream.ValueInputStream;
import java.util.Map;
import java.util.Objects;

public class InputStreamSources {
    private final Map<StreamId, InputStreamSource<?>> streamSources;

    public InputStreamSources(Map<StreamId, InputStreamSource<?>> streamSources) {
        this.streamSources = ImmutableMap.copyOf(Objects.requireNonNull(streamSources, "streamSources is null"));
    }

    public <S extends ValueInputStream<?>> InputStreamSource<S> getInputStreamSource(OrcColumn column, Stream.StreamKind streamKind, Class<S> streamType) {
        Objects.requireNonNull(column, "column is null");
        Objects.requireNonNull(streamType, "streamType is null");
        InputStreamSource<Object> streamSource = this.streamSources.get(new StreamId(column.getColumnId(), streamKind));
        if (streamSource == null) {
            streamSource = MissingInputStreamSource.missingStreamSource(streamType);
        }
        Preconditions.checkArgument((boolean)streamType.isAssignableFrom(streamSource.getStreamType()), (String)"%s must be of type %s, not %s", (Object)column, (Object)streamType.getName(), (Object)streamSource.getStreamType().getName());
        return streamSource;
    }
}

