/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.orc.DiskRange;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.stream.MemoryOrcDataReader;
import io.trino.orc.stream.OrcDataReader;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class CachingOrcDataSource
implements OrcDataSource {
    private final OrcDataSource dataSource;
    private final RegionFinder regionFinder;
    private long cachePosition;
    private int cacheLength;
    private Slice cache;

    public CachingOrcDataSource(OrcDataSource dataSource, RegionFinder regionFinder) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.regionFinder = Objects.requireNonNull(regionFinder, "regionFinder is null");
        this.cache = Slices.EMPTY_SLICE;
    }

    @Override
    public OrcDataSourceId getId() {
        return this.dataSource.getId();
    }

    @Override
    public long getReadBytes() {
        return this.dataSource.getReadBytes();
    }

    @Override
    public long getReadTimeNanos() {
        return this.dataSource.getReadTimeNanos();
    }

    @Override
    public long getEstimatedSize() {
        return this.dataSource.getEstimatedSize();
    }

    @Override
    public long getRetainedSize() {
        return this.dataSource.getRetainedSize();
    }

    @VisibleForTesting
    void readCacheAt(long offset) throws IOException {
        DiskRange newCacheRange = this.regionFinder.getRangeFor(offset);
        this.cachePosition = newCacheRange.getOffset();
        this.cacheLength = newCacheRange.getLength();
        this.cache = this.dataSource.readFully(newCacheRange.getOffset(), this.cacheLength);
    }

    @Override
    public Slice readTail(int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice readFully(long position, int length) throws IOException {
        if (position < this.cachePosition) {
            throw new IllegalArgumentException(String.format("read request (offset %d length %d) is before cache (offset %d length %d)", position, length, this.cachePosition, this.cacheLength));
        }
        if (position >= this.cachePosition + (long)this.cacheLength) {
            this.readCacheAt(position);
        }
        if (position + (long)length > this.cachePosition + (long)this.cacheLength) {
            throw new IllegalArgumentException(String.format("read request (offset %d length %d) partially overlaps cache (offset %d length %d)", position, length, this.cachePosition, this.cacheLength));
        }
        return this.cache.slice(Math.toIntExact(position - this.cachePosition), length);
    }

    @Override
    public <K> Map<K, OrcDataReader> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            Slice buffer = this.readFully(diskRange.getOffset(), diskRange.getLength());
            builder.put(entry.getKey(), (Object)new MemoryOrcDataReader(this.dataSource.getId(), buffer, buffer.length()));
        }
        return builder.buildOrThrow();
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    public String toString() {
        return this.dataSource.toString();
    }

    public static interface RegionFinder {
        public DiskRange getRangeFor(long var1);
    }
}

