/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Arrays;
import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Sketch;

public abstract class CompactSketch
extends Sketch {
    @Override
    public CompactSketch compact() {
        return this;
    }

    @Override
    public CompactSketch compact(boolean dstOrdered, WritableMemory dstMem) {
        return this;
    }

    @Override
    public Family getFamily() {
        return Family.COMPACT;
    }

    @Override
    public boolean isCompact() {
        return true;
    }

    static final long[] compactCache(long[] srcCache, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = srcCache.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered && curCount > 1) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final long[] compactCachePart(long[] srcCache, int lgArrLongs, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = 1 << lgArrLongs;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final Memory loadCompactMemory(long[] compactCache, short seedHash, int curCount, long thetaLong, WritableMemory dstMem, byte flags, int preLongs) {
        assert (dstMem != null && compactCache != null);
        int outLongs = preLongs + curCount;
        int outBytes = outLongs << 3;
        int dstBytes = (int)dstMem.getCapacity();
        if (outBytes > dstBytes) {
            throw new SketchesArgumentException("Insufficient Memory: " + dstBytes + ", Need: " + outBytes);
        }
        byte famID = (byte)Family.COMPACT.getID();
        PreambleUtil.insertPreLongs(dstMem, preLongs);
        PreambleUtil.insertSerVer(dstMem, 3);
        PreambleUtil.insertFamilyID(dstMem, famID);
        PreambleUtil.insertFlags(dstMem, flags);
        PreambleUtil.insertSeedHash(dstMem, seedHash);
        if (preLongs == 1 && curCount == 1) {
            dstMem.putLong(8L, compactCache[0]);
            return dstMem;
        }
        if (preLongs > 1) {
            PreambleUtil.insertCurCount(dstMem, curCount);
            PreambleUtil.insertP(dstMem, 1.0f);
        }
        if (preLongs > 2) {
            PreambleUtil.insertThetaLong(dstMem, thetaLong);
        }
        if (curCount > 0) {
            dstMem.putLongArray((long)(preLongs << 3), compactCache, 0, curCount);
        }
        return dstMem;
    }
}

