/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.CouponList;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HeapAuxHashMap;
import org.apache.datasketches.hll.Hll4Array;
import org.apache.datasketches.hll.Hll6Array;
import org.apache.datasketches.hll.Hll8Array;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.ToByteArrayImpl;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

abstract class HllArray
extends AbstractHllArray {
    boolean oooFlag = false;
    boolean rebuildCurMinNumKxQ = false;
    int curMin;
    int numAtCurMin;
    double hipAccum;
    double kxq0;
    double kxq1;
    byte[] hllByteArr = null;
    final int configKmask;

    HllArray(int lgConfigK, TgtHllType tgtHllType) {
        super(lgConfigK, tgtHllType, CurMode.HLL);
        this.curMin = 0;
        this.numAtCurMin = 1 << lgConfigK;
        this.hipAccum = 0.0;
        this.kxq0 = 1 << lgConfigK;
        this.kxq1 = 0.0;
        this.configKmask = (1 << lgConfigK) - 1;
    }

    HllArray(HllArray that) {
        super(that.getLgConfigK(), that.getTgtHllType(), CurMode.HLL);
        this.oooFlag = that.isOutOfOrderFlag();
        this.rebuildCurMinNumKxQ = that.isRebuildCurMinNumKxQFlag();
        this.curMin = that.getCurMin();
        this.numAtCurMin = that.getNumAtCurMin();
        this.hipAccum = that.getHipAccum();
        this.kxq0 = that.getKxQ0();
        this.kxq1 = that.getKxQ1();
        this.hllByteArr = (byte[])that.hllByteArr.clone();
        AuxHashMap thatAuxMap = that.getAuxHashMap();
        if (thatAuxMap != null) {
            this.putAuxHashMap(thatAuxMap.copy(), false);
        } else {
            this.putAuxHashMap(null, false);
        }
        this.configKmask = (1 << this.lgConfigK) - 1;
    }

    static final HllArray newHeapHll(int lgConfigK, TgtHllType tgtHllType) {
        if (tgtHllType == TgtHllType.HLL_4) {
            return new Hll4Array(lgConfigK);
        }
        if (tgtHllType == TgtHllType.HLL_6) {
            return new Hll6Array(lgConfigK);
        }
        return new Hll8Array(lgConfigK);
    }

    @Override
    void addToHipAccum(double delta) {
        this.hipAccum += delta;
    }

    @Override
    void decNumAtCurMin() {
        --this.numAtCurMin;
    }

    @Override
    int getCurMin() {
        return this.curMin;
    }

    @Override
    CurMode getCurMode() {
        return this.curMode;
    }

    @Override
    double getHipAccum() {
        return this.hipAccum;
    }

    @Override
    int getHllByteArrBytes() {
        return this.hllByteArr.length;
    }

    @Override
    double getKxQ0() {
        return this.kxq0;
    }

    @Override
    double getKxQ1() {
        return this.kxq1;
    }

    @Override
    int getLgConfigK() {
        return this.lgConfigK;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    AuxHashMap getNewAuxHashMap() {
        return new HeapAuxHashMap(HllUtil.LG_AUX_ARR_INTS[this.lgConfigK], this.lgConfigK);
    }

    @Override
    int getNumAtCurMin() {
        return this.numAtCurMin;
    }

    @Override
    WritableMemory getWritableMemory() {
        return null;
    }

    @Override
    boolean isCompact() {
        return false;
    }

    @Override
    boolean isEmpty() {
        return false;
    }

    @Override
    boolean isMemory() {
        return false;
    }

    @Override
    boolean isOffHeap() {
        return false;
    }

    @Override
    boolean isOutOfOrderFlag() {
        return this.oooFlag;
    }

    @Override
    boolean isSameResource(Memory mem) {
        return false;
    }

    @Override
    boolean isRebuildCurMinNumKxQFlag() {
        return this.rebuildCurMinNumKxQ;
    }

    @Override
    void putAuxHashMap(AuxHashMap auxHashMap, boolean compact) {
        this.auxHashMap = auxHashMap;
    }

    @Override
    void putCurMin(int curMin) {
        this.curMin = curMin;
    }

    @Override
    void putEmptyFlag(boolean empty) {
    }

    @Override
    void putHipAccum(double value) {
        this.hipAccum = value;
    }

    @Override
    void putKxQ0(double kxq0) {
        this.kxq0 = kxq0;
    }

    @Override
    void putKxQ1(double kxq1) {
        this.kxq1 = kxq1;
    }

    @Override
    void putNumAtCurMin(int numAtCurMin) {
        this.numAtCurMin = numAtCurMin;
    }

    @Override
    void putOutOfOrderFlag(boolean oooFlag) {
        this.oooFlag = oooFlag;
    }

    @Override
    void putRebuildCurMinNumKxQFlag(boolean rebuild) {
        this.rebuildCurMinNumKxQ = rebuild;
    }

    @Override
    HllSketchImpl reset() {
        return new CouponList(this.lgConfigK, this.tgtHllType, CurMode.LIST);
    }

    @Override
    byte[] toCompactByteArray() {
        return this.toUpdatableByteArray();
    }

    @Override
    byte[] toUpdatableByteArray() {
        return ToByteArrayImpl.toHllByteArray(this, false);
    }

    static final void extractCommonHll(Memory srcMem, HllArray hllArray) {
        hllArray.putOutOfOrderFlag(PreambleUtil.extractOooFlag(srcMem));
        hllArray.putEmptyFlag(PreambleUtil.extractEmptyFlag(srcMem));
        hllArray.putCurMin(PreambleUtil.extractCurMin(srcMem));
        hllArray.putHipAccum(PreambleUtil.extractHipAccum(srcMem));
        hllArray.putKxQ0(PreambleUtil.extractKxQ0(srcMem));
        hllArray.putKxQ1(PreambleUtil.extractKxQ1(srcMem));
        hllArray.putNumAtCurMin(PreambleUtil.extractNumAtCurMin(srcMem));
        hllArray.putRebuildCurMinNumKxQFlag(PreambleUtil.extractRebuildCurMinNumKxQFlag(srcMem));
        srcMem.getByteArray((long)PreambleUtil.HLL_BYTE_ARR_START, hllArray.hllByteArr, 0, hllArray.hllByteArr.length);
    }
}

