/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.browser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.singlestore.jdbc.plugin.credential.Credential;
import java.time.Instant;

public class ExpiringCredential {
    private static final long EXPIRATION_OFFSET_MILLISECONDS = 100L;
    private final Instant expiration;
    private final Credential credential;
    private final String email;

    public ExpiringCredential(@JsonProperty(value="credential") Credential credential, @JsonProperty(value="email") String email, @JsonProperty(value="expiration") Instant expiration) {
        this.credential = credential;
        this.expiration = expiration;
        this.email = email;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.expiration.isAfter(Instant.now().plusMillis(100L));
    }

    public Credential getCredential() {
        return this.credential;
    }

    public String getEmail() {
        return this.email;
    }

    public Instant getExpiration() {
        return this.expiration;
    }
}

